;  ###----------------------------------------------------------------###
;  #									#
;  # file	: loadstore      					#
;  # date	: Feb 22, 1995  					#
;  # descr.	: test set instructions        				#
;  #									#
;  ###----------------------------------------------------------------###


		org	X"8000_0000"
		start	init

imm_p2		equ	X"0002"
imm_p3		equ	X"0003"
imm_n2		equ	X"fffe"
imm_n3		equ	X"fffd"

init:		
		lis	r1, imm_p2
		lis	r2, imm_p3
		lis	r3, imm_n2
		lis	r4, imm_n3
		liu	r5, imm_n2
		liu	r6, imm_n3
					;1.) seq/sne/seqi/snei
		seq	r7, r1, r1	
		beqz	r7, error
		seq.i	r7, r2, imm_p3
		beqz	r7, error
		sne	r7, r3, r3
		bnez	r7, error
		sne.i	r7, r4, imm_n3
		bnez	r7, error
					;2.) sequ/sneu/sequi/sneui
		sequ	r7, r1, r1		
		beqz	r7, error
		sequ.i	r7, r2, imm_p3
		beqz	r7, error
		sneu	r7, r3, r3
		bnez	r7, error
		sneu.i	r7, r6, imm_n3
		bnez	r7, error					
					;3.) sgt
		sgt	r7, r1, r2	;2>3?
		bnez	r7, error
		sgt	r7, r1, r3	;2>-2?
		beqz	r7, error
		sgt	r7, r2, r1	;3>2?
		beqz	r7, error
		sgt	r7, r3, r4	;-2>-3?
		beqz	r7, error 
		sgt	r7, r4, r3	;-3>-2?
		bnez	r7, error 

					;4.) sgtu
		sgtu	r7, r1, r2	;2>3?
		bnez	r7, error
		sgtu	r7, r1, r3	;2>...65534?
		bnez	r7, error
		sgtu	r7, r2, r1	;3>2?
		beqz	r7, error
		sgtu	r7, r3, r4	;...65534>...65533?
		beqz	r7, error 
		sgtu	r7, r4, r3	;...65533>...65534?
		bnez	r7, error 

					;5.) sgti
		sgt.i	r7, r1, imm_p3	;2>3?
		bnez	r7, error
		sgt.i	r7, r1, imm_n2	;2>-2?
		beqz	r7, error
		sgt.i	r7, r2, imm_p2	;3>2?
		beqz	r7, error
		sgt.i	r7, r3, imm_n3	;-2>-3?
		beqz	r7, error 
		sgt.i	r7, r4, imm_n2	;-3>-2?
		bnez	r7, error 

					;6.) sgtui
		sgtu.i	r7, r1, imm_p3	;2>3?
		bnez	r7, error
		sgtu.i	r7, r1, imm_n2	;2>65534?
		bnez	r7, error
		sgtu.i	r7, r2, imm_p2	;3>2?
		beqz	r7, error
		sgtu.i	r7, r5, imm_n3	;65534>65533?
		beqz	r7, error 
		sgtu.i	r7, r6, imm_n2	;65533>65534?
		bnez	r7, error 

					;7.) slt
		slt	r7, r1, r2	;2<3?
		beqz	r7, error
		slt	r7, r1, r3	;2<-2?
		bnez	r7, error
		slt	r7, r2, r1	;3<2?
		bnez	r7, error
		slt	r7, r3, r4	;-2<-3?
		bnez	r7, error 
		slt	r7, r4, r3	;-3<-2?
		beqz	r7, error 

					;8.) sltu
		sltu	r7, r1, r2	;2<3?
		beqz	r7, error
		sltu	r7, r1, r3	;2<...65534?
		beqz	r7, error
		sltu	r7, r2, r1	;3<2?
		bnez	r7, error
		sltu	r7, r3, r4	;...65534<...65533?
		bnez	r7, error 
		sltu	r7, r4, r3	;...65533<...65534?
		beqz	r7, error 

					;9.) slti
		slt.i	r7, r1, imm_p3	;2<3?
		beqz	r7, error
		slt.i	r7, r1, imm_n2	;2<-2?
		bnez	r7, error
		slt.i	r7, r2, imm_p2	;3<2?
		bnez	r7, error
		slt.i	r7, r3, imm_n3	;-2<-3?
		bnez	r7, error 
		slt.i	r7, r4, imm_n2	;-3<-2?
		beqz	r7, error 

					;10.) sltui
		sltu.i	r7, r1, imm_p3	;2<3?
		beqz	r7, error
		sltu.i	r7, r1, imm_n2	;2<65534?
		beqz	r7, error
		sltu.i	r7, r2, imm_p2	;3<2?
		bnez	r7, error
		sltu.i	r7, r5, imm_n3	;65534<65533?
		bnez	r7, error 
		sltu.i	r7, r6, imm_n2	;65533<65534?
		beqz	r7, error 

					;11.) sge
		sge	r7, r1, r2	;2>=3?
		bnez	r7, error
		sge	r7, r1, r1	;2>=2?
		beqz	r7, error		
                sge	r7, r1, r3	;2>=-2?
		beqz	r7, error
		sge	r7, r2, r1	;3>=2?
		beqz	r7, error
		sge	r7, r3, r4	;-2>=-3?
		beqz	r7, error 
		sge	r7, r4, r3	;-3>=-2?
		bnez	r7, error 

					;12.) sgeu
		sgeu	r7, r1, r2	;2>=3?
		bnez	r7, error
		sgeu	r7, r1, r1	;2>=2?
		beqz	r7, error		
		sgeu	r7, r1, r3	;2>=...65534?
		bnez	r7, error
		sgeu	r7, r2, r1	;3>=2?
		beqz	r7, error
		sgeu	r7, r3, r4	;...65534>=...65533?
		beqz	r7, error 
		sgeu	r7, r4, r3	;...65533>=...65534?
		bnez	r7, error 

					;13.) sgei
		sge.i	r7, r1, imm_p3	;2>=3?
		bnez	r7, error
		sge.i	r7, r1, imm_p2	;2>=2?
		beqz	r7, error		
		sge.i	r7, r1, imm_n2	;2>=-2?
		beqz	r7, error
		sge.i	r7, r2, imm_p2	;3>=2?
		beqz	r7, error
		sge.i	r7, r3, imm_n3	;-2>=-3?
		beqz	r7, error 
		sge.i	r7, r4, imm_n2	;-3>=-2?
		bnez	r7, error 

					;14.) sgeui
		sgeu.i	r7, r1, imm_p3	;2>=3?
		bnez	r7, error
		sgeu.i	r7, r1, imm_p2	;2>=2?
		beqz	r7, error
		sgeu.i	r7, r1, imm_n2	;2>=65534?
		bnez	r7, error
		sgeu.i	r7, r2, imm_p2	;3>=2?
		beqz	r7, error
		sgeu.i	r7, r5, imm_n3	;65534>=65533?
		beqz	r7, error 
		sgeu.i	r7, r6, imm_n2	;65533>=65534?
		bnez	r7, error 

					;15.) sle
		sle	r7, r1, r2	;2<=3?
		beqz	r7, error
		sle	r7, r1, r1	;2<=2?
		beqz	r7, error		
                sle	r7, r1, r3	;2<=-2?
		bnez	r7, error
		sle	r7, r2, r1	;3<=2?
		bnez	r7, error
		sle	r7, r3, r4	;-2<=-3?
		bnez	r7, error 
		sle	r7, r4, r3	;-3<=-2?
		beqz	r7, error 

					;16.) sleu
		sleu	r7, r1, r2	;2<=3?
		beqz	r7, error
		sleu	r7, r1, r1	;2<=2?
		beqz	r7, error		
		sleu	r7, r1, r3	;2<=...65534?
		beqz	r7, error
		sleu	r7, r2, r1	;3<=2?
		bnez	r7, error
		sleu	r7, r3, r4	;...65534<=...65533?
		bnez	r7, error 
		sleu	r7, r4, r3	;...65533<=...65534?
		beqz	r7, error 

					;17.) slei
		sle.i	r7, r1, imm_p3	;2<=3?
		beqz	r7, error
		sle.i	r7, r1, imm_p2	;2<=2?
		beqz	r7, error		
		sle.i	r7, r1, imm_n2	;2<=-2?
		bnez	r7, error
		sle.i	r7, r2, imm_p2	;3<=2?
		bnez	r7, error
		sle.i	r7, r3, imm_n3	;-2<=-3?
		bnez	r7, error 
		sle.i	r7, r4, imm_n2	;-3<=-2?
		beqz	r7, error 

					;18.) sleui
		sleu.i	r7, r1, imm_p3	;2<=3?
		beqz	r7, error
		sleu.i	r7, r1, imm_p2	;2<=2?
		beqz	r7, error
		sleu.i	r7, r1, imm_n2	;2<=65534?
		beqz	r7, error
		sleu.i	r7, r2, imm_p2	;3<=2?
		bnez	r7, error
		sleu.i	r7, r5, imm_n3	;65534<=65533?
		bnez	r7, error 
		sleu.i	r7, r6, imm_n2	;65533<=65534?
		beqz	r7, error 

		j	ok		;test ok
			        
		org 	X"0000_1000"
error		nop
		j	error

		org 	X"0000_2000"
ok		j	ok

		end
