/*===========================+==========================================*/
/*									*/
/* file		: dxlasm_dlx.lex  					*/
/* version	: v0.1							*/
/* date		: Jan 20 1994						*/
/* author	: Pirouz BAZARGAN SABET					*/
/* version	: v1.1							*/
/* date		: Sept 30 1995						*/
/* author	: Martin Gumm    					*/
/* description	: DLX assembler - lex rules				*/
/* comment      :  modified version of the DLX assembler                */
/*									*/
/*======================================================================*/


%{
#include <stdio.h>
#include MUT_H
#include "dlxasm_type.h"
#include "y.tab.h"
#include "dlxasm_defs.h"
#include "dlxasm_lex.h"
%}


digit			[0-9]
i_registre		[rR]({digit}|[012]{digit}|3[01])
f_evn_registre          [fF]([02468]|[012][02468]|30)
f_odd_registre          [fF]([13579]|[012][13579]|31)
hexadecimal_valu	[xX]\"[0-9a-fA-F](_?[0-9a-fA-F])*\"
octal_valu		[oO]\"[0-7](_?[0-7])*\"
binary_valu		[bB]\"[0-1](_?[0-1])*\"
decimal_valu		{digit}+
letter			[a-zA-Z]
letter_or_digit		{letter}|{digit}
ident			(_|"."|{letter_or_digit})+

%%
\n				{
/*printf ("CarriageReturn : %d\n", DLX_LINNUM);*/
			DLX_LINNUM++;
			return (CarriageReturn);
				}
\:				{
/*printf ("Colon\n");*/
			return (Colon);
				}
[ \t]				{
/*printf ("space\n");*/
				}
\&				{
/*printf ("Ampersand\n");*/
			return (Ampersand);
				}
\|				{
/*printf ("Bar\n");*/
			return (Bar);
				}
\^				{
/*printf ("Circomflex\n");*/
			return (Circomflex);
				}
\+				{
/*printf ("Plus\n");*/
			return (Plus);
				}
\*				{
/*printf ("Star\n");*/
			return (Star);
				}
\<\<				{
/*printf ("DoubleLess\n");*/
			return (DoubleLess);
				}
\>\>				{
/*printf ("DoubleGreat\n");*/
			return (DoubleGreat);
				}
\-				{
/*printf ("Minus\n");*/
			return (Minus);
				}
\(				{
/*printf ("LeftParen\n");*/
			return (LeftParen);
				}
\)				{
/*printf ("RightParen\n");*/
			return (RightParen);
				}
\,				{
/*printf ("Comma\n");*/
			return (Comma);
				}
{i_registre}			{
/*printf ("IntegerRegister : %s\n", yytext);*/
			sscanf (&yytext[1], "%lu", &yylval.valu);
			return (IntegerRegister);
				}
{f_odd_registre}		{
/*printf ("OFloatRegister : %s\n", yytext);*/
			sscanf (&yytext[1], "%lu", &yylval.valu);
			return (OFloatRegister);
				}
{f_evn_registre}		{
/*printf ("EFloatRegister : %s\n", yytext);*/
			sscanf (&yytext[1], "%lu", &yylval.valu);
			return (EFloatRegister);
				}
{hexadecimal_valu}		{
/*printf ("Literal (X) : %s\n", yytext);*/
 			yylval.valu = hextoint (yytext);
			return (Litteral);
				}
{octal_valu}			{
/*printf ("Literal (O) : %s\n", yytext);*/
 			yylval.valu = octtoint (yytext);
			return (Litteral);
				}
{binary_valu}			{
/*printf ("Literal (B) : %s\n", yytext);*/
 			yylval.valu = bintoint (yytext);
			return (Litteral);
				}
{decimal_valu}			{
/*printf ("Literal (D) : %s\n", yytext);*/
 			if (sscanf (yytext, "%lu", &yylval.valu) == 0)
			  yylval.valu = 0;
			return (Litteral);
				}

{ident}				{
			int code;

			yylval.text = namealloc (yytext);
			code = dlx_search (yylval.text);
			if (code == -1)
			  {
/*printf ("Identifier : %s\n", yytext);*/
			  return (Identifier);
			  }
			else
			  {
/*printf ("Key Word : %s\n", yytext);*/
			  yylval.valu = code;
			  switch (code)
			  {
			   /* Codop: Codop_aaa                                */
			   /*  aaa : dest.|src1|src2                          */
                           /*  a : I = Integer Register; F = Float Register   */
			   /*      D = Double Register ; S = Special Register */
                           /*      M = Integer Register for load/store        */
                           /*      R = Integer Register for index load/store  */
                           /*      0 = unused                                 */
                           /*      i = 16-bit immediate; l = 26-bit immediate */

                            case _ADD:   case _ADDU:
			    case _SUB:   case _SUBU:
			    case _SLL:   case _SRL:
                            case _SRA:   case _AND:
                            case _OR:    case _XOR:
			    case _SEQ:   case _SNE:
			    case _SGE:   case _SLE:
			    case _SGT:   case _SLT:
			    case _SEQU:  case _SNEU:
			    case _SGEU:  case _SLEU:
			    case _SGTU:  case _SLTU:
			      return (Codop_III);	/* rd, rs1, rs2 */

			    case _LW:    case _LH:
			    case _LHU:   case _LB:
			    case _LBU:
			      return (Codop_IMR);      /* rd, rs1, rs2 */ 

			    case _SW:    case _SH:
			    case _SB:
			      return (Codop_MIR);	/* rd, rs1, rs2 */

			    case _MULT:  case _MULTU:
			    case _DIV:   case _DIVU:
			    case _ADDF:  case _SUBF:
			    case _MULTF: case _DIVF:
			      return (Codop_FFF);	/* rd, rs1, rs2 */
			    
			    case _ADDD:  case _SUBD:
			    case _MULTD: case _DIVD:
			      return (Codop_DDD);	/* rd, rs1, rs2 */

                            case _ADD_I: case _ADDU_I:
			    case _SUB_I: case _SUBU_I:
			    case _AND_I: case _OR_I:
                            case _XOR_I: case _SLL_I:
                            case _SRL_I: case _SRA_I:
			    case _SEQ_I: case _SNE_I:
			    case _SGE_I: case _SLE_I:
			    case _SGT_I: case _SLT_I:
			    case _SEQU_I: case _SNEU_I:
			    case _SGEU_I: case _SLEU_I:
			    case _SGTU_I: case _SLTU_I:
			      return (Codop_IIi);	/*rd, rs, imm*/

                            case _LH_I:   case _LHU_I:
			    case _LB_I:   case _LBU_I:
                            case _LW_I:
                              return (Codop_IMi);	/*rd, rs, imm*/

			    case _SW_I:    case _SH_I:
                            case _SB_I:
                              return (Codop_MIi);	/*rd, rs, imm*/
			    
			    case _LF:   
			      return (Codop_FMR);	/*rd, rs1, rs2*/

			    case _SF:
			      return (Codop_MFR);	/*rd, rs1, rs2*/

			    case _LD:
			      return (Codop_DMR);	/*rd, rs1, rs2*/

			    case _SD:
			      return (Codop_MDR);	/*rd, rs1, rs2*/

			    case _LF_I:  
			      return (Codop_FMi);	/*rd, rs, imm*/

			    case _SF_I:
			      return (Codop_MFi);	/*rd, rs, imm*/

			    case _LD_I:
			      return (Codop_DMi);	/*rd, rs, imm*/

			    case _SD_I:
			      return (Codop_MDi);	/*rd, rs, imm*/

                            case _MOVF:
			      return (Codop_FF0);	/* source2 unused */

                            case _MOVD:
			      return (Codop_DD0);	/* source2 unused */

                            case _CVTF2I: case _CVTI2F:
			      return (Codop_FF0);	/* source2 unused */

                            case _CVTF2D: case _CVTI2D:
			      return (Codop_DF0);	/* source2 unused */

			    case _CVTD2F: case _CVTD2I:
			      return (Codop_FD0);	/* source2 unused */

                            case _MOVFP2I:
			      return (Codop_IF0);	/* source2 unused */

                            case _MOVI2FP:
			      return (Codop_FI0);	/* source2 unused */

                            case _MOVS2I:
			      return (Codop_IS0);	/* source2 unused */
			    
                            case _MOVI2S:
			      return (Codop_SI0);	/* source2 unused */

                            case _EQF:    case _NEF:
                            case _LTF:    case _LEF:
                            case _GTF:    case _GEF:
			      return (Codop_0FF);	/* dest. unused */
			    
                            case _EQD:    case _NED:
                            case _LTD:    case _LED:
                            case _GTD:    case _GED:
			      return (Codop_0DD);	/* dest. unused */

 			    case _BEQZ:
			    case _BNEZ:
			      return (Codop_0Ii);	/* dest. unused */

			    case _BFPT:
			    case _BFPF:
			      return (Codop_00i);	/* no register */

			    case _LHI:
			      return (Codop_I0i);	/* source1 unused */

			    case _JR: 
			    case _JALR:
			      return (Codop_0I0);	/* dest. and imm. unused */

			    case _J:
			    case _JAL:
			      return (Codop_j_l);	/* only 26-bit-imm. */

			    case _TRAP:
			      return (Codop_t_l);	/* only 26-bit-imm. */

			    case _RFE:
			      return (Codop_000);       /* zero address instr. */

			    case _END: case _START:
			    case _EQU: case _ORG:
			      return (code);

			    case _NOP:
			      return (Macro_nop);

			    case _LIW:
			      return (Macro_liw);

                            case _LIS:
                              return (Macro_lis);

                            case _LIU:
                              return (Macro_liu);

                            case _MOV:
                              return (Macro_mov);

                            case _CLR:
                              return (Macro_clr);

                            case _NOT:
                              return (Macro_not);

			    case _IAR: case _ICR: case _FPSR: case _TBR:
			      return (SpecialRegister);
			  }  /* end switch */

			}
		}
\;.*$				{
/*printf ("Comment : %s\n", yytext);*/
				}
%%

/*---------------------------------------------------------*/
/* function dlx_search                                     */
/* search for code in hashtab                              */
/*---------------------------------------------------------*/

static int dlx_search (str)

char *str;
{
  static ht *hashpt = NULL;

  if (hashpt == NULL)
  {
    hashpt = addht (128);

    addhtitem (hashpt, namealloc ("iar"), _IAR );
    addhtitem (hashpt, namealloc ("icr"), _ICR );
    addhtitem (hashpt, namealloc ("tbr"), _TBR );

    addhtitem (hashpt, namealloc ("end"), _END );
    addhtitem (hashpt, namealloc ("org"), _ORG );
    addhtitem (hashpt, namealloc ("start"), _START );
    addhtitem (hashpt, namealloc ("equ"), _EQU );

    addhtitem (hashpt, namealloc ("nop"), _NOP);
    addhtitem (hashpt, namealloc ("liw"), _LIW);
    addhtitem (hashpt, namealloc ("lis"), _LIS);
    addhtitem (hashpt, namealloc ("liu"), _LIU);
    addhtitem (hashpt, namealloc ("mov"), _MOV);
    addhtitem (hashpt, namealloc ("clr"), _CLR);
    addhtitem (hashpt, namealloc ("not"), _NOT);

    addhtitem (hashpt, namealloc ("lw"), _LW);
    addhtitem (hashpt, namealloc ("lh"), _LH);
    addhtitem (hashpt, namealloc ("lb"), _LB);
    addhtitem (hashpt, namealloc ("sw"), _SW);
    addhtitem (hashpt, namealloc ("sh"), _SH);
    addhtitem (hashpt, namealloc ("sb"), _SB);
    addhtitem (hashpt, namealloc ("lw.i"), _LW_I);
    addhtitem (hashpt, namealloc ("lh.i"), _LH_I);
    addhtitem (hashpt, namealloc ("lb.i"), _LB_I);
    addhtitem (hashpt, namealloc ("sw.i"), _SW_I);
    addhtitem (hashpt, namealloc ("sh.i"), _SH_I);
    addhtitem (hashpt, namealloc ("sb.i"), _SB_I);
    addhtitem (hashpt, namealloc ("j"), _J);
    addhtitem (hashpt, namealloc ("jal"), _JAL);
    addhtitem (hashpt, namealloc ("jr"), _JR);
    addhtitem (hashpt, namealloc ("jalr"), _JALR);
    addhtitem (hashpt, namealloc ("beqz"), _BEQZ);
    addhtitem (hashpt, namealloc ("bnez"), _BNEZ);
    addhtitem (hashpt, namealloc ("rfe"), _RFE);
    addhtitem (hashpt, namealloc ("trap"), _TRAP);
    addhtitem (hashpt, namealloc ("add.i"), _ADD_I);
    addhtitem (hashpt, namealloc ("sub.i"), _SUB_I);
    addhtitem (hashpt, namealloc ("and.i"), _AND_I);
    addhtitem (hashpt, namealloc ("or.i"), _OR_I);
    addhtitem (hashpt, namealloc ("xor.i"), _XOR_I);
    addhtitem (hashpt, namealloc ("lhi"), _LHI);
    addhtitem (hashpt, namealloc ("sll.i"), _SLL_I);
    addhtitem (hashpt, namealloc ("srl.i"), _SRL_I);
    addhtitem (hashpt, namealloc ("sra.i"), _SRA_I);
    addhtitem (hashpt, namealloc ("seq.i"), _SEQ_I);
    addhtitem (hashpt, namealloc ("sne.i"), _SNE_I);
    addhtitem (hashpt, namealloc ("slt.i"), _SLT_I);
    addhtitem (hashpt, namealloc ("sle.i"), _SLE_I);
    addhtitem (hashpt, namealloc ("sgt.i"), _SGT_I);
    addhtitem (hashpt, namealloc ("sge.i"), _SGE_I);

    addhtitem (hashpt, namealloc ("nop"), _NOP);
    addhtitem (hashpt, namealloc ("movs2i"), _MOVS2I);	 
    addhtitem (hashpt, namealloc ("movi2s"), _MOVI2S);
    addhtitem (hashpt, namealloc ("add"), _ADD);
    addhtitem (hashpt, namealloc ("sub"), _SUB);
    addhtitem (hashpt, namealloc ("and"), _AND);
    addhtitem (hashpt, namealloc ("or"), _OR);
    addhtitem (hashpt, namealloc ("xor"), _XOR);
    addhtitem (hashpt, namealloc ("sll"), _SLL);
    addhtitem (hashpt, namealloc ("srl"), _SRL);
    addhtitem (hashpt, namealloc ("sra"), _SRA);
    addhtitem (hashpt, namealloc ("seq"), _SEQ);
    addhtitem (hashpt, namealloc ("sne"), _SNE);
    addhtitem (hashpt, namealloc ("slt"), _SLT);
    addhtitem (hashpt, namealloc ("sle"), _SLE);
    addhtitem (hashpt, namealloc ("sgt"), _SGT);
    addhtitem (hashpt, namealloc ("sge"), _SGE);

    if (DLX_ARCHIT != DLX_INT_SIMPLE)
    {
      addhtitem (hashpt, namealloc ("lhu"), _LHU);
      addhtitem (hashpt, namealloc ("lbu"), _LBU);
      addhtitem (hashpt, namealloc ("lhu.i"), _LHU_I);
      addhtitem (hashpt, namealloc ("lbu.i"), _LBU_I);
      addhtitem (hashpt, namealloc ("addu.i"), _ADDU_I);
      addhtitem (hashpt, namealloc ("subu.i"), _SUBU_I);
      addhtitem (hashpt, namealloc ("sequ.i"), _SEQU_I);
      addhtitem (hashpt, namealloc ("sneu.i"), _SNEU_I);
      addhtitem (hashpt, namealloc ("sltu.i"), _SLTU_I);
      addhtitem (hashpt, namealloc ("sleu.i"), _SLEU_I);
      addhtitem (hashpt, namealloc ("sgtu.i"), _SGTU_I);
      addhtitem (hashpt, namealloc ("sgeu.i"), _SGEU_I);

      addhtitem (hashpt, namealloc ("addu"), _ADDU);
      addhtitem (hashpt, namealloc ("subu"), _SUBU);
      addhtitem (hashpt, namealloc ("sequ"), _SEQU);
      addhtitem (hashpt, namealloc ("sneu"), _SNEU);
      addhtitem (hashpt, namealloc ("sltu"), _SLTU);
      addhtitem (hashpt, namealloc ("sleu"), _SLEU);
      addhtitem (hashpt, namealloc ("sgtu"), _SGTU);
      addhtitem (hashpt, namealloc ("sgeu"), _SGEU);
    }

    if ((DLX_ARCHIT != DLX_INT_SIMPLE) && (DLX_ARCHIT != DLX_INT_S_AND_U))
    {
      addhtitem (hashpt, namealloc ("mult"), _MULT);
      addhtitem (hashpt, namealloc ("div"), _DIV);
      addhtitem (hashpt, namealloc ("multu"), _MULT);
      addhtitem (hashpt, namealloc ("divu"), _DIVU);
    }

    if (DLX_ARCHIT == DLX_FLOAT)
    {
      addhtitem (hashpt, namealloc ("fpsr"), _FPSR);

      addhtitem (hashpt, namealloc ("lf"), _LF);
      addhtitem (hashpt, namealloc ("ld"), _LD);
      addhtitem (hashpt, namealloc ("sf"), _SF);
      addhtitem (hashpt, namealloc ("sd"), _SD);
      addhtitem (hashpt, namealloc ("lf.i"), _LF_I);
      addhtitem (hashpt, namealloc ("ld.i"), _LD_I);
      addhtitem (hashpt, namealloc ("sf.i"), _SF_I);
      addhtitem (hashpt, namealloc ("sd.i"), _SD_I);
      addhtitem (hashpt, namealloc ("bfpt"), _BFPT);
      addhtitem (hashpt, namealloc ("bfpf"), _BFPF);	

      addhtitem (hashpt, namealloc ("movf"), _MOVF);
      addhtitem (hashpt, namealloc ("movd"), _MOVD);
      addhtitem (hashpt, namealloc ("movfp2i"), _MOVFP2I);
      addhtitem (hashpt, namealloc ("movi2fp"), _MOVI2FP);

      addhtitem (hashpt, namealloc ("addf"), _ADDF);
      addhtitem (hashpt, namealloc ("subf"), _SUBF);
      addhtitem (hashpt, namealloc ("multf"), _MULTF);
      addhtitem (hashpt, namealloc ("divf"), _DIVF);
      addhtitem (hashpt, namealloc ("addd"), _ADDD);
      addhtitem (hashpt, namealloc ("subd"), _SUBD);
      addhtitem (hashpt, namealloc ("multd"), _MULTD);
      addhtitem (hashpt, namealloc ("divd"), _DIVD);
      addhtitem (hashpt, namealloc ("cvtf2d"), _CVTF2D);
      addhtitem (hashpt, namealloc ("cvtf2i"), _CVTF2I);
      addhtitem (hashpt, namealloc ("cvtd2f"), _CVTD2F);
      addhtitem (hashpt, namealloc ("cvtd2i"), _CVTD2I);
      addhtitem (hashpt, namealloc ("cvti2f"), _CVTI2F);
      addhtitem (hashpt, namealloc ("cvti2d"), _CVTI2D);
      addhtitem (hashpt, namealloc ("eqf"), _EQF);
      addhtitem (hashpt, namealloc ("nef"), _NEF);
      addhtitem (hashpt, namealloc ("ltf"), _LTF);
      addhtitem (hashpt, namealloc ("lef"), _LEF);
      addhtitem (hashpt, namealloc ("gtf"), _GTF);
      addhtitem (hashpt, namealloc ("gef"), _GEF);
      addhtitem (hashpt, namealloc ("eqd"), _EQD);
      addhtitem (hashpt, namealloc ("ned"), _NED);
      addhtitem (hashpt, namealloc ("ltd"), _LTD);
      addhtitem (hashpt, namealloc ("led"), _LED);
      addhtitem (hashpt, namealloc ("gtd"), _GTD);
      addhtitem (hashpt, namealloc ("ged"), _GED);
    }
     
  }
  return (gethtitem (hashpt, str));
}

/*------------------------------------------------*/
/* function hextoint                              */
/* converts hexadecimal (string) to integer       */
/*------------------------------------------------*/

static unsigned long hextoint (str)

char *str;

  {
  unsigned long valu = 0;
  char          c    = 0;

  while ((c = *str) != '\0')
    {
    if ((c >= '0') && (c <= '9'))
      valu = (valu << 4) + c - '0';
    else
      if ((c >= 'a') && (c <= 'f'))
        valu = (valu << 4) + c - 'a' + 10;
      else
        if ((c >= 'A') && (c <= 'F'))
          valu = (valu << 4) + c - 'A' + 10;
    str++;
    }

  return (valu);
  }

/*------------------------------------------------*/
/* function octtoint                              */
/* converts octal (string) to integer             */
/*------------------------------------------------*/

static unsigned long octtoint (str)

char *str;

  {
  unsigned long valu = 0;
  char          c    = 0;

  while ((c = *str) != '\0')
    {
    if ((c >= '0') && (c <= '7'))
      valu = (valu << 3) + c - '0';

    str++;
    }

  return (valu);
  }

/*------------------------------------------------*/
/* function bintoint                              */
/* converts binary (string) to integer            */
/*------------------------------------------------*/

static unsigned long bintoint (str)

char *str;

  {
  unsigned long valu = 0;
  char          c    = 0;

  while ((c = *str) != '\0')
    {
    if ((c == '0') || (c == '1'))
      valu = (valu << 1) + c - '0';

    str++;
    }

  return (valu);
  }











