--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture declaration for the rom
--    generated by the DLX_ASM assembler v1.0
--    (C) v1.1 M.Gumm / (C) v0.1 P. Bazrgan Sabet
--
--  (input file: jump1.asm)
--  (vhdl file : rom-behaviour_jump1.vhd)
--------------------------------------------------------------------------

architecture behaviour_jump1 of rom is

begin
 
-- word addressable rom (size 64Kbyte : 16 bit address)
 
  process
    variable address : natural;
  begin
    --
    -- initialize outputs
    --
    d_bus <= (others => 'Z') after tpd;
    ready <= 'Z' after tpd;
      --
      -- wait until rom is enabled
      --
      wait until Is_1H(enable);
      ready <= '0' after tpd;
      --
      -- decode address and perform command if selected
      --
      address := sv_to_natural(a_bus);
      wait for tac; 			-- read access time
      case address is
        when 16#0000# => d_bus <= To_StdLogicVector(X"30000ffc");
        when 16#1000# => d_bus <= To_StdLogicVector(X"6c1d8000");
        when 16#1004# => d_bus <= To_StdLogicVector(X"67bd8764");
        when 16#1008# => d_bus <= To_StdLogicVector(X"3ba00000");
        when 16#8764# => d_bus <= To_StdLogicVector(X"37ffa898");
        when 16#8768# => d_bus <= To_StdLogicVector(X"33ffa898");
        when 16#3000# => d_bus <= To_StdLogicVector(X"3be00000");
        when 16#3004# => d_bus <= To_StdLogicVector(X"6c1c8000");
        when 16#3008# => d_bus <= To_StdLogicVector(X"679cfff0");
        when 16#300c# => d_bus <= To_StdLogicVector(X"3f800000");
        when 16#3010# => d_bus <= To_StdLogicVector(X"3000cfe0");
        when 16#fff0# => d_bus <= To_StdLogicVector(X"3be00000");
        when 16#fff4# => d_bus <= To_StdLogicVector(X"33fffffc");
        when others   => d_bus <= (others => 'X');
      end case;
      ready <= '1' after tpd;
      --
      -- wait for acceptance of data
      --
      wait until Is_0L(enable);
 
  end process;
 
end behaviour_jump1;
