--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Behavioural architecture of shifter
--
--  file word_shifter-behaviour.vhd
--------------------------------------------------------------------------

library IEEE_EXTD;
  use IEEE_EXTD.stdl1164_vector_arithmetic.all;

architecture behaviour of word_shifter is
begin
  
  shift_op: process (a, lr_switch, ar_switch, shift)    
    variable tmp : dlx_word;
  begin
    case lr_switch is
      when '0' =>
	sv_sll(a, tmp, shift);
      when '1' => 
	case ar_switch is
	  when '0' =>
	    sv_srl(a, tmp, shift);
          when '1' =>
 	    sv_sra(a, tmp, shift);
          when others => 
	    tmp := (others => 'X');
	end case;    	
      when others =>
	tmp := (others => 'X');
    end case;
    b <= tmp after tpd_out;  
  end process shift_op;
  
end behaviour;



