--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  carry-look-ahead  architecture of adder (signed add /
--  hierarchical version)
--
--  file word_adder-cla_h.vhd
--------------------------------------------------------------------------

architecture cla_h of word_adder is

  component cla_a 
  port (a0,b0,a1,b1,c0 : in std_logic;
        s0,s1,p_n, g_n : out std_logic);
  end component;

  component cla_b
  port (p_0_1,p_2_3,p_4_5,p_6_7: std_logic;
        g_0_1,g_2_3,g_4_5,g_6_7: in std_logic;
        c_in : in std_logic;
	p_n, g_n : out std_logic;
	c0,c2,c4,c6 : out std_logic);
  end component;
  
  component  cla_b_end
  port (p_0_1,p_2_3,p_4_5,p_6_7: std_logic;
        g_0_1,g_2_3,g_4_5,g_6_7: in std_logic;
        c_in : in std_logic;
	c0,c2,c4,c6 : out std_logic;
	g_n : out std_logic);
  end component;

  signal c_l1 : std_logic_vector(0 to 15);
  signal p_l1, g_l1 : std_logic_vector(0 to 15);
  signal c_l2 : std_logic_vector(0 to 3);
  signal p_l2 : std_logic_vector(0 to 7);
  signal g_l2 : std_logic_vector(0 to 7);
  signal s31_tmp : std_logic;
  signal a_tmp, b_tmp : std_logic_vector(31 downto 0);
  
begin
  a_tmp <= a;
  b_tmp <= b;

  a_0: cla_a
      port map (a_tmp(0), b_tmp(0), a_tmp(1), b_tmp(1), c_l1(0),
                s(0), s(1), p_l1(0), g_l1(0) );
  a_1: cla_a
      port map (a_tmp(2), b_tmp(2), a_tmp(3), b_tmp(3), c_l1(1),
                s(2), s(3), p_l1(1), g_l1(1) );
  a_2: cla_a
      port map (a_tmp(4), b_tmp(4), a_tmp(5), b_tmp(5), c_l1(2),
                s(4), s(5), p_l1(2), g_l1(2) );
  a_3: cla_a
      port map (a_tmp(6), b_tmp(6), a_tmp(7), b_tmp(7), c_l1(3),
                s(6), s(7), p_l1(3), g_l1(3) );
  a_4: cla_a
      port map (a_tmp(8), b_tmp(8), a_tmp(9), b_tmp(9), c_l1(4),
                s(8), s(9), p_l1(4), g_l1(4) );
  a_5: cla_a
      port map (a_tmp(10), b_tmp(10), a_tmp(11), b_tmp(11), c_l1(5),
                s(10), s(11), p_l1(5), g_l1(5) );
  a_6: cla_a
      port map (a_tmp(12), b_tmp(12), a_tmp(13), b_tmp(13), c_l1(6),
                s(12), s(13), p_l1(6), g_l1(6) );
  a_7: cla_a
      port map (a_tmp(14), b_tmp(14), a_tmp(15), b_tmp(15), c_l1(7),
                s(14), s(15), p_l1(7), g_l1(7) );
  a_8: cla_a
      port map (a_tmp(16), b_tmp(16), a_tmp(17), b_tmp(17), c_l1(8),
                s(16), s(17), p_l1(8), g_l1(8) );
  a_9: cla_a
      port map (a_tmp(18), b_tmp(18), a_tmp(19), b_tmp(19), c_l1(9),
                s(18), s(19), p_l1(9), g_l1(9) );
  a_10: cla_a
      port map (a_tmp(20), b_tmp(20), a_tmp(21), b_tmp(21), c_l1(10),
                s(20), s(21), p_l1(10), g_l1(10) );
  a_11: cla_a
      port map (a_tmp(22), b_tmp(22), a_tmp(23), b_tmp(23), c_l1(11),
                s(22), s(23), p_l1(11), g_l1(11) );
  a_12: cla_a
      port map (a_tmp(24), b_tmp(24), a_tmp(25), b_tmp(25), c_l1(12),
                s(24), s(25), p_l1(12), g_l1(12) );
  a_13: cla_a
      port map (a_tmp(26), b_tmp(26), a_tmp(27), b_tmp(27), c_l1(13),
                s(26), s(27), p_l1(13), g_l1(13) );
  a_14: cla_a
      port map (a_tmp(28), b_tmp(28), a_tmp(29), b_tmp(29), c_l1(14),
                s(28), s(29), p_l1(14), g_l1(14) );
  a_15: cla_a
      port map (a_tmp(30), b_tmp(30), a_tmp(31), b_tmp(31), c_l1(15),
                s(30), s31_tmp, p_l1(15), g_l1(15) );

  b_0: cla_b
      port map (p_l1(0),p_l1(1),p_l1(2),p_l1(3),
	        g_l1(0),g_l1(1),g_l1(2),g_l1(3),
                c_l2(0),
	      	p_l2(0), g_l2(0),
		c_l1(0),c_l1(1),c_l1(2),c_l1(3));
  b_1: cla_b
      port map (p_l1(4),p_l1(5),p_l1(6),p_l1(7),
	        g_l1(4),g_l1(5),g_l1(6),g_l1(7),
                c_l2(1),
	      	p_l2(1), g_l2(1),
		c_l1(4),c_l1(5),c_l1(6),c_l1(7));
  b_2: cla_b
      port map (p_l1(8),p_l1(9),p_l1(10),p_l1(11),
	        g_l1(8),g_l1(9),g_l1(10),g_l1(11),
                c_l2(2),
	      	p_l2(2), g_l2(2),
		c_l1(8),c_l1(9),c_l1(10),c_l1(11));
  b_3: cla_b
      port map (p_l1(12),p_l1(13),p_l1(14),p_l1(15),
	        g_l1(12),g_l1(13),g_l1(14),g_l1(15),
                c_l2(3),
	      	p_l2(3), g_l2(3),
		c_l1(12),c_l1(13),c_l1(14),c_l1(15));
  
  b_end: cla_b_end
    port map (p_l2(0),p_l2(1),p_l2(2),p_l2(3),
              g_l2(0),g_l2(1),g_l2(2),g_l2(3),
	      c_in,
	      c_l2(0),c_l2(1),c_l2(2),c_l2(3),
	      c_out);

  ovfl <= ((a(31) and b(31)) and not s31_tmp) or
          ((not a(31) and not b(31)) and s31_tmp);

  s(31) <= s31_tmp;
  
end cla_h;


