--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------
--  
--  (file system-config.vhd)
--------------------------------------------------------------------------

configuration system_config OF system IS

  for structural

    for test_dlx : dlx
      
      --USE entity WORK.dlx(behaviour_s)
      --  GENERIC MAP (tpd_behav => 5 ns,
      --  	       DEBUG => true);
      
      USE configuration WORK.dlx_config_rtl_1;
    end for;
    
    FOR test_sysram : DLX_BENCH.dlx_b_components.ram
      USE configuration DLX_BENCH.ram_config_1
    	generic map (tpd => 3 ns,
 	             tac => 20 ns,
 		     mem_size => 16#4000#);   -- 4*16 KByte = 64 KByte
    end for;

    FOR test_useram : DLX_BENCH.dlx_b_components.ram
      USE configuration DLX_BENCH.ram_config_1
    	generic map (tpd => 3 ns,
 	             tac => 20 ns,
 		     mem_size => 16#4000#);   -- 4*16 KByte = 64 KByte
    end for;
    
    FOR test_timer : DLX_BENCH.dlx_b_components.timer
      USE ENTITY DLX_BENCH.timer(behaviour)
    	GENERIC MAP (tpd => 5 ns);
    end for;

    FOR test_clock : DLX_BENCH.dlx_b_components.clockgen
      USE ENTITY DLX_BENCH.clockgen(dataflow)
    	GENERIC MAP (tpw => 45 ns,          -- clock pulse width
      	             tps => 5 ns);          -- clock pulse separation = 10 MHz
    end for;

    FOR test_userom : DLX_BENCH.dlx_b_components.rom
      USE ENTITY DLX_BENCH.rom(behaviour_intrpt1)
      	GENERIC MAP (tpd => 3 ns, tac => 20 ns);
    end for;

    FOR test_sysrom : DLX_BENCH.dlx_b_components.rom
      USE ENTITY DLX_BENCH.rom(behaviour_system)
      	GENERIC MAP (tpd => 3 ns, tac => 20 ns);
    end for;
	
    FOR test_decoder: DLX_BENCH.dlx_b_components.decoder
      USE ENTITY DLX_BENCH.decoder(dataflow)
        generic MAP (tpd => 5 ns,	        -- input to output delay
                     MONITOR => true);	        -- flag for debugging 
    end for;

  end for;

end system_config;

