--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Dataflow architecture of in/out pad
--  
--  (file pad_io-dataflow.vhd)
--------------------------------------------------------------------------

architecture dataflow of pad_io is
begin

  pad <= core2pad after tpd_c2p when io_sel = '0' else
         'Z' after tpd_c2p when io_sel = '1' else 
         'X' after tpd_c2p;

  pad2core <= pad after tpd_p2c;

  --synopsys synthesis_off
  --
  -- modelling of unknow intervall durin gswitch
  --
  pad <= 'X' after tpd_c2p,
         'Z' after tpd_c2p + t_switch when not io_sel'stable else
         'Z';
  --synopsys synthesis_on

end dataflow;


