--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Dataflow descrition of the 32-to-1-muxoder
--  
--  (file mux_32_1-behaviour.vhd)
--------------------------------------------------------------------------

architecture behaviour of mux_32_1 is

begin 

  mux : process (mux_in, mux_sel)
  begin
    case mux_sel is
      when "00000" => mux_out <= mux_in(0) after tpd_mux;
      when "00001" => mux_out <= mux_in(1) after tpd_mux;
      when "00010" => mux_out <= mux_in(2) after tpd_mux;
      when "00011" => mux_out <= mux_in(3) after tpd_mux;
      when "00100" => mux_out <= mux_in(4) after tpd_mux;
      when "00101" => mux_out <= mux_in(5) after tpd_mux;
      when "00110" => mux_out <= mux_in(6) after tpd_mux;
      when "00111" => mux_out <= mux_in(7) after tpd_mux;
      when "01000" => mux_out <= mux_in(8) after tpd_mux;
      when "01001" => mux_out <= mux_in(9) after tpd_mux;
      when "01010" => mux_out <= mux_in(10) after tpd_mux;
      when "01011" => mux_out <= mux_in(11) after tpd_mux;
      when "01100" => mux_out <= mux_in(12) after tpd_mux;
      when "01101" => mux_out <= mux_in(13) after tpd_mux;
      when "01110" => mux_out <= mux_in(14) after tpd_mux;
      when "01111" => mux_out <= mux_in(15) after tpd_mux;
      when "10000" => mux_out <= mux_in(16) after tpd_mux;
      when "10001" => mux_out <= mux_in(17) after tpd_mux;
      when "10010" => mux_out <= mux_in(18) after tpd_mux;
      when "10011" => mux_out <= mux_in(19) after tpd_mux;
      when "10100" => mux_out <= mux_in(20) after tpd_mux;
      when "10101" => mux_out <= mux_in(21) after tpd_mux;        
      when "10110" => mux_out <= mux_in(22) after tpd_mux;
      when "10111" => mux_out <= mux_in(23) after tpd_mux;
      when "11000" => mux_out <= mux_in(24) after tpd_mux;
      when "11001" => mux_out <= mux_in(25) after tpd_mux;
      when "11010" => mux_out <= mux_in(26) after tpd_mux;
      when "11011" => mux_out <= mux_in(27) after tpd_mux;
      when "11100" => mux_out <= mux_in(28) after tpd_mux;
      when "11101" => mux_out <= mux_in(29) after tpd_mux;
      when "11110" => mux_out <= mux_in(30) after tpd_mux;
      when "11111" => mux_out <= mux_in(31) after tpd_mux;
      when others  => mux_out <= 'X' after tpd_mux; 
    end case;	
  end process mux;

end behaviour;



