--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the instruction decoder 3
--  (decoer 3 generates select signals for generation of rd and
--   for the selection of either tbr, icr, or iar)
--
--  file ir_decode_3.vhd
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all,
    WORK.dlx_instructions.all;
use WORK.control_types.all;

entity ir_decode_3 is 
  generic (tpd_dec : Time);                           -- decoder delay
  port (instr_in : in dlx_word;
        s1_sel        : out std_logic;
	rd_s2_adr_sel : out std_logic;
	rd_adr_set31  : out std_logic;
	priv_ins_out  : out std_logic);
end ir_decode_3;


