--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  entity declaration of the DLX processor
--  
--  (file dlx.vhd)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.dlx_types.all;

entity dlx is
  generic (                                 -- behaviour model
           tpd_behav : Time := 0 ns;        -- clock to output delay
	   DEBUG: boolean := false);        -- debugging mode
  port (a_bus  : out dlx_address;
       	d_bus  : inout dlx_word bus;
        enable : out dlx_nibble;
	rw     : out std_logic;
	error  : out std_logic;
        ready  : in std_logic;
	reset  : in std_logic;             -- asynchronous reset 
	halt   : in std_logic;             -- freeze of processor state
	intrpt : in dlx_nibble;            -- interupt signals (maskable)
        phi1   : in std_logic;             -- 2 phase non overlapping clock
	phi2   : in std_logic);

end dlx;





