--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the 1-to-32 demux
--  (low_acitve out: unselected outputs = '1')
--
--  (file demux_1_32.vhd)
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all;

entity  demux_1_32 is
  generic (tpd_demux : Time);
  port (demux_in  : in  std_logic;
      	demux_out : out dlx_word;
	demux_sel : in std_logic_vector(0 to 4));
end demux_1_32;




