--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for controller
--
--  (file controller.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
  --
  -- source for s1 bus (low activ signals)
  -- |a|icr|iar|tbr|mdr|immed|consta| (b/pc/mar not connected to s1 bus)
  -- X : icr or iar or tbr, for mov instructions
  --
  -- source for s2 bus (low activ signals)
  -- |b|immed|pc|mar|constb|  (a/mdr/icr/tbr/iar not connected to s2 bus)
  -- Y : b or immed, depends on instruction
  --
  -- destination from dest bus (low activ signals)
  -- |c|icr|iar|tbr|pc|mar|mdr|
  -- X : icr or iar or tbr, for mov instruction
  --
  -- select constant 
  -- |sel_const(0:1)|
  --
  -- select immediate
  -- |size_imm|sign_imm|
  --
  -- register file operation
  -- (ab<-rf, rf<-c)
  -- |ab_rf|rf_c|
  --
  -- alu operation(0 to 3)
  --
  -- exception bit set
  -- |s|ioc|irra|iav|dav|ovad|ovar|priv|
  --
  -- memory control signals (ir_en, pad_out_en : low active)
  -- |ir_en|addr_mux|mdr_mux|enab(0 to 3)|rw|pad_d_inout|pad_out_en|error|
  --
  -- mdr shift control signals mdr_sh_ctrl(0 to2)
  --     "0--" load/store word
  --     "100" load half 
  --     "101" load byte 
  --     "110" store half
  --     "111" store byte 
  -- 
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all;
use WORK.dlx_instructions.all;
use WORK.control_types.all;

entity controller is 
  port (phi1, phi2 : in std_logic;                  -- two phase clock in
	reset : in std_logic;                       -- reset input
	halt  : in std_logic;                       -- halt input
	ready : in std_logic;                       -- mem. ready input
	instr_in : in dlx_word;                     -- instruction input
	alu_zero : in std_logic;                    -- alu zero bit
	alu_neg  : in std_logic;                    -- alu negative bit
	alu_ovfl : in std_logic;                    -- alu overflow bit
	intrpt   : in std_logic;                    -- interrupt active
	super    : in std_logic;                    -- supervisor bit 
	adr_msb : in std_logic;                     -- ms address bit
	adr_ls2 : in std_logic_vector(1 downto 0);  -- least sign. 2 addr. bits
        --
	-- reg. address outputs
	--
	rs1_out : out dlx_reg_addr;
	rs2_out : out dlx_reg_addr;	  
	rd_out  : out dlx_reg_addr;	  
        --
	-- control outputs
	--
	s1_enab     : out std_logic_vector(0 to 6);    -- select s1 source
	s2_enab     : out std_logic_vector(0 to 4);    -- select s2_source
	dest_enab   : out std_logic_vector(0 to 6);    -- select destination
	alu_op_sel  : out std_logic_vector(0 to 3);    -- alu operation
	const_sel   : out std_logic_vector(0 to 1);    -- select const for s1
	rf_op_sel   : out std_logic_vector(0 to 1);    -- select reg file operation
	immed_sel   : out std_logic_vector(0 to 1);    -- select immediate from ir
	exc_enab    : out std_logic_vector(0 to 7);    -- enable set exception bit
	mem_ctrl    : out std_logic_vector(0 to 10);   -- memory control lines
        mdr_sh_ctrl : out std_logic_vector(0 to 2));   -- mdr shift control
end controller;




