--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Structrual architecture of ALU
--
--  file alu-structural.vhd
--------------------------------------------------------------------------

architecture structural of alu is

  component  word_latch
    port (d : in  dlx_word;
      	  q : out dlx_word;
	  latch_en : std_logic);
  end component;

  component  word_mux2 
    port (in0, in1 : in dlx_word;
          y   : out dlx_word;
	  sel : in std_logic);
  end component;

  component  word_mux4
    port (in0, in1, in2, in3 : in dlx_word;
      	  y   : out dlx_word;
	  sel : in std_logic_vector(0 to 1));
  end component;

  component word_alu_logic 
    port (a, b : in dlx_word;
      	  y   : out dlx_word;
	  sel : in std_logic_vector(0 to 1));
  end component;

  component word_adder
    port (a : in std_logic_vector(31 downto 0);
      	  b : in std_logic_vector(31 downto 0);
	  c_in : in std_logic;
	  s : out std_logic_vector(31 downto 0);
	  c_out : out std_logic;
          ovfl : out std_logic);
  end component;

  component word_shifter
    port (a : in dlx_word;
 	  shift : std_logic_vector(4 downto 0);  
          lr_switch : in std_logic;
	  ar_switch : in std_logic;
	  b : out dlx_word);
  end component;

  signal stored_s1, stored_s2, mux_s2 : dlx_word;
  signal tmp_res: dlx_word;
  signal adder_out, shifter_out, logic_out, pass_out : dlx_word;
  signal adder_ovfl : std_logic;
  
begin

  latch_s1 : word_latch
    port map (d => s1 ,q => stored_s1, latch_en => latch_en);
      
  latch_s2 : word_latch
    port map (d => s2 ,q => stored_s2, latch_en => latch_en);

  --
  -- invert s2 when subtract
  --
  mux_s2 <= stored_s2 when func(3) = '0' else
            not stored_s2;
      
  the_adder : word_adder
    port map (a => stored_s1, b => mux_s2, c_in => func(3), s => adder_out,
              c_out => open, ovfl => adder_ovfl);

  the_shifter : word_shifter
    port map (a => stored_s1, shift => stored_s2(27 to 31),
              lr_switch => func(3), ar_switch => func(2), b => shifter_out);

  the_pass_mux : word_mux2
    port map (in0 => stored_s1, in1 => stored_s2, y => pass_out,
              sel => func(3));

  the_alu_logic : word_alu_logic
    port map (a => stored_s1, b => stored_s2, y => logic_out,
              sel => func(2 to 3));

  the_out_mux : word_mux4
    port map (in0 => pass_out, in1 => adder_out, in2 => shifter_out,
              in3 => logic_out, y => tmp_res, sel => func(0 to 1));
      	      
  zero <= '1' when tmp_res = To_stdlogicvector(X"0000_0000") else '0';
  overflow <= adder_ovfl and (not func(0) and func(1));
  negative <= tmp_res(0);
  result <= tmp_res;
  
end structural;





