--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Behavioural architecture of ALU
--
--  file alu-behaviour.vhd
--------------------------------------------------------------------------

architecture behaviour of alu is
  signal stored_s1, stored_s2 : dlx_word;
begin

  latch: process (s1, s2, latch_en)
  begin
    if latch_en = '0' then
      stored_s1 <= To_UX01(s1) after tpd_latch;
      stored_s2 <= To_UX01(s2) after tpd_latch;
    end if;
  end process latch;
  
  alu_op: process (stored_s1, stored_s2, func)    
    variable tmp_res : dlx_word;
    variable tmp_ovl : std_logic;
  begin
    case func(0 to 1) is
      when "00" =>
	case func(3) is
	  when '0' =>
	    tmp_res := stored_s1;
	  when '1' =>
	    tmp_res := stored_s2;
          when others =>
	    tmp_res := (others => 'X');
	end case;
      when "01" =>
	case func(3) is
	  when '0' =>
	    sv_add(stored_s1, stored_s2, tmp_res, tmp_ovl);
	  when '1' =>
	    sv_sub(stored_s1, stored_s2, tmp_res, tmp_ovl);
          when others => 
	    tmp_res := (others => 'X');
	end case;    	
      when "10" =>
	case func(2 to 3) is
	  when "00" | "01" => 
	    sv_sll(stored_s1, tmp_res, stored_s2(27 to 31));
	  when "10" =>
	    sv_srl(stored_s1, tmp_res, stored_s2(27 to 31));
          when "11" =>
	    sv_sra(stored_s1, tmp_res, stored_s2(27 to 31));
          when others => 
	    tmp_res := (others => 'X');
	end case;    	
      when "11" =>
	case func(2 to 3) is
	  when "00" =>
	    tmp_res := stored_s1 and stored_s2;
	  when "01" =>
	    tmp_res := stored_s1 or stored_s2;
          when "10" | "11" =>
	    tmp_res := stored_s1 xor stored_s2;
          when others => 
	    tmp_res := (others => 'X');
	end case;
      when others =>
	tmp_res := (others => 'X');
    end case;
    
    result <= tmp_res after tpd_out;
    if tmp_res = To_StdLogicVector(X"0000_0000") then
      zero <= '1' after tpd_out;
    else
      zero <= '0' after tpd_out;
    end if;
    negative <= tmp_res(0) after tpd_out;
    overflow <= tmp_ovl after tpd_out;
  end process alu_op;
  
end behaviour;

