--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture for test bench for the word_adder
--  Test for arithmetical functions
--
--  (file word_adder_test-bench.vhd)
--------------------------------------------------------------------------

architecture bench of word_adder_test is

  component word_adder
    port (a : in std_logic_vector(31 downto 0);
      	  b : in std_logic_vector(31 downto 0);
	  cin : in std_logic;
	  s : out std_logic_vector(31 downto 0);
	  c_out : out std_logic;
	  ovfl : out std_logic);
  end component;


signal a_sig, b_sig, s_sig : std_logic_vector(31 downto 0);
signal c_in_sig, ovfl_sig, c_out_sig : std_logic;
  
begin

  test_adder : word_adder
    port map (a_sig, b_sig, c_in_sig, s_sig, c_out_sig, ovfl_sig);


  test : process
    variable L : line;
  begin
    write(L, string'("  2+2+(cin=0) = "));
    a_sig <= To_StdLogicVector(X"0000_0002");
    b_sig <= To_StdLogicVector(X"0000_0002");
    c_in_sig <= '0';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"0000_0004") and ovfl_sig = '0' and c_out_sig = '0';
    wait for 1 ns;
    
    write(L, string'("  2+2+(cin=1) = "));
    a_sig <= To_StdLogicVector(X"0000_0002");
    b_sig <= To_StdLogicVector(X"0000_0002");
    c_in_sig <= '1';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"0000_0005") and ovfl_sig = '0' and c_out_sig = '0';
    wait for 1 ns;
    
    write(L, string'("  2+(-2)+(cin=0) = "));
    a_sig <= To_StdLogicVector(X"0000_0002");
    b_sig <= To_StdLogicVector(X"ffff_fffe");
    c_in_sig <= '0';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"0000_0000") and ovfl_sig = '0' and c_out_sig = '1';
    wait for 1 ns;

    write(L, string'("  2+(-2)+(cin=1) = "));
    a_sig <= To_StdLogicVector(X"0000_0002");
    b_sig <= To_StdLogicVector(X"ffff_fffe");
    c_in_sig <= '1';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"0000_0001") and ovfl_sig = '0' and c_out_sig = '1';
    wait for 1 ns;

    write(L, string'("  1234_5678+2345_6789+(cin=0) = "));
    a_sig <= To_StdLogicVector(X"1234_5678");
    b_sig <= To_StdLogicVector(X"2345_6789");
    c_in_sig <= '0';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"3579_be01") and ovfl_sig = '0' and c_out_sig = '0';
    wait for 1 ns;

    write(L, string'("  1234_5678+2345_6789+(cin=1) = "));
    a_sig <= To_StdLogicVector(X"1234_5678");
    b_sig <= To_StdLogicVector(X"2345_6789");
    c_in_sig <= '1';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"3579_be02") and ovfl_sig = '0' and c_out_sig = '0';
    wait for 1 ns;

    write(L, string'("  7fff_fffe+0000_0001+(cin=1) = "));
    a_sig <= To_StdLogicVector(X"7fff_fffe");
    b_sig <= To_StdLogicVector(X"0000_0001");
    c_in_sig <= '1';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"8000_0000") and ovfl_sig = '1' and c_out_sig = '0';
    wait for 1 ns;

    write(L, string'("  (-4)+(-2)+(cin=0) = "));
    a_sig <= To_StdLogicVector(X"ffff_fffc");
    b_sig <= To_StdLogicVector(X"ffff_fffe");
    c_in_sig <= '0';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"ffff_fffa") and ovfl_sig = '0' and c_out_sig = '1';
    wait for 1 ns;

    write(L, string'("  (-4)+(-2)+(cin=1) = "));
    a_sig <= To_StdLogicVector(X"ffff_fffc");
    b_sig <= To_StdLogicVector(X"ffff_fffe");
    c_in_sig <= '1';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"ffff_fffb") and ovfl_sig = '0' and c_out_sig = '1';
    wait for 1 ns;
    
    write(L, string'("  (-7fff_ffff)+(-2)+(cin=0) = "));
    a_sig <= To_StdLogicVector(X"8000_0001");
    b_sig <= To_StdLogicVector(X"ffff_fffe");
    c_in_sig <= '0';
    wait for 1 ns;
    write(L, s_sig, X, down);
    write(L, string'(", carry = "));  write(L, c_out_sig);
    write(L, string'(", overflow = "));  write(L, ovfl_sig);
    writeline(output, L);
    assert s_sig = To_StdLogicVector(X"7fff_ffff") and ovfl_sig = '1' and c_out_sig = '1';
    wait for 1 ns;
        
    wait;

  end process test;
end bench;

