--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Package to make visible all parts of the DLX library
--  
--  (file dlx_components.vhd)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;

library DLX;
use DLX.dlx_types.all;

package dlx_components is

  COMPONENT dlx
  generic (-- behaviour model
           tpd_behav : Time := 0 ns;       -- clock to output delay 
	   -- debugging mode
           DEBUG: boolean := false);       -- debugging mode

    PORT (a_bus  : out dlx_address;
       	  d_bus  : inout dlx_word bus;
          enable : out std_logic_vector(0 to 1);
	  rw     : out std_logic;
          ready  : in std_logic;
	  reset  : in std_logic;             -- asynchronous reset 
	  halt   : in std_logic;             -- asynchronous halt of processor
	  intrpt : in dlx_nibble;            -- interupt signals (maskable)
          phi1   : in std_logic;             -- 2 phase non overlapping clock
	  phi2   : in std_logic);
  END COMPONENT;

end dlx_components;






