--------------------------------------------------
--  32-bit Barrel Shifter implemented as a 
--  tree shifter with three stages
--
--  Alan R. Martello, University of Pittsburgh
--------------------------------------------------


entity BARREL32 is
    port (data_in:  in bit_vector(31 downto 0); 
          shift:    in bit_vector(4 downto 0);
          data_out: out bit_vector(31 downto 0)
         );
end BARREL32;

architecture logic of BARREL32 is
    signal buffer_0, buffer_1, buffer_2, buffer_3 : bit_vector(31 downto 0);
begin

   --
   --  stage one, shift one bit if needed
   --
   buffer_0(31 downto 0) <= 
       data_in(30 downto 0) & data_in(31) when shift(0) = '1'
       else data_in(31 downto 0);

   --
   --  stage two, shift two bits if needed
   --
   buffer_1(31 downto 0) <= 
       buffer_0(29 downto 0) & buffer_0(31 downto 30) 
       when shift(1) = '1' else buffer_0(31 downto 0);

   --
   --  stage three, shift four bits if needed
   --
   buffer_2(31 downto 0) <= 
       buffer_1(27 downto 0) & buffer_1(31 downto 28)
       when shift(2) = '1' else buffer_1(31 downto 0);

   --
   --  stage four, shift 8 bits if needed
   --
   buffer_3(31 downto 0) <= 
       buffer_2(23 downto 0) & buffer_2(31 downto 24) 
       when shift(3) = '1' else buffer_2(31 downto 0);

   --
   --  stage five, shift 16 bits if needed
   --
   data_out(31 downto 0) <= 
       buffer_3(15 downto 0) & buffer_3(31 downto 16)
       when shift(4) = '1' else buffer_3(31 downto 0);

end logic;
