--------------------------------------------------
--  8-bit Barrel Shifter implemented as a 
--  tree shifter with three stages
--
--  Alan R. Martello, University of Pittsburgh
--------------------------------------------------


entity BARREL is
    port (data_in:  in bit_vector(7 downto 0); 
          shift:    in bit_vector(2 downto 0);
          data_out: out bit_vector(7 downto 0)
         );
end BARREL;

architecture logic of BARREL is
    signal buffer_a, buffer_b: bit_vector(7 downto 0);
begin

   --
   --  stage one, shift one bit if needed
   --
   buffer_a(7 downto 0) <= 
       data_in(6 downto 0) & data_in(7) when shift(0) = '1'
       else data_in(7 downto 0);

   --
   --  stage two, shift two bits if needed
   --
   buffer_b(7 downto 0) <= 
       buffer_a(5 downto 0) & buffer_a(7 downto 6) 
       when shift(1) = '1' else buffer_a(7 downto 0);

   --
   --  stage three, shift four bits if needed
   --
   data_out(7 downto 0) <= 
       buffer_b(3 downto 0) & buffer_b(7 downto 4)
       when shift(2) = '1' else buffer_b(7 downto 0);

end logic;
