-- ****************************************************************************
-- *                                                                          *
-- *  THIS MODULE PERFORMS DIGITAL TO ANALOG CONVERSION USING FUNCTIONS       *
-- *              IN THE PACKAGE "INTERFACE_PACK.vhdl"                        *
-- *                                                                          *
-- ****************************************************************************

use work.COMPUTE_PACK.all;
use work.IO_PACK.all;
use work.INTERFACE_PACK.all;
use STD.TEXTIO.all;

entity D2A is
   port (LOGIC_IN      : in SWITCH_LEVEL;      -- Digital voltage input.
         Time_in       : in TIME;              -- Simulation time from AnaVHDL.
         stop_after    : in TIME;              -- Simulation end time.
         ANALOG_OUTPUT : out real);            -- Analog voltage output.
end D2A;

architecture D2A of D2A is

  signal logic_value : logic_array(1 to 1000); -- Array for storing digital input
  signal ana_out     : real;                  -- Analog voltage output.
  signal t           : TIME;
  signal t1          : TIME;
  signal t2          : TIME;
  signal stop        : TIME;
  signal delta       : TIME := 0 ns;


file FILE2 :TEXT is out "STD_OUTPUT";

begin


  p1  : process

        variable j   : positive;
        variable K   : LINE;         -- debugg variable.

    begin

     t <= Time_in;                  -- Simulation time is assigned to a signal.
     stop <= stop_after;

-- To store the input logic values into the array.

     if (t >= 0 ns and t < (stop - 1 ns)) then -- stop_after is the time after 
                                          -- which the simulation has to stop.
         logic_value(j) <= LOGIC_IN;   -- logic_value = array for storing the 
                                       -- digital input values.
         j := j + 1;
     end if;
     wait for 1 ns;

  end process p1;


  p2 : process

        variable d1 : time := 0 ns;       -- d1 : time at which 'X' starts.
        variable d2 : time := 0 ns;       -- d2 : time at which 'X' ends.
        variable j  : positive;
        variable K  : LINE;

      begin


      if LOGIC_IN = 'X' then
         d1 := t;
         wait until LOGIC_IN = '0' or LOGIC_IN = '1';
         d2 := t;
      end if;
      delta <= abs(d1 - d2);
      wait for 1 ns;

  end process p2;


  p3  : process

-- This process converts digital values into analog voltage values for three
-- logic levels '0','1' & 'X'.

        variable delta_real : real;         
        variable t_real     : real;
        variable Ref_time   : TIME := 1 ns;        -- Constant reference time.
        variable Ref_time_real: real;
        variable j          : positive;
        variable probe      : integer;
        variable K          : LINE;                -- debugg variable.

     begin

      t1 <= Time_in;                 -- Simulation time is assigned to a signal.
      t_real := TIME_TO_REAL(t1);                  -- Time t to real.
      Ref_time_real := TIME_TO_REAL(Ref_time);     -- time Ref_time to real.
      delta_real := TIME_TO_REAL(delta);           -- Time delta to real.
      if (t1 >= 0 ns and t1 < (stop - 1 ns)) then
       wait for 0 ns;
       if logic_value(1) = '0' then
          probe := 0;
       elsif logic_value(1) = '1' then
          probe := 1;
       end if;
      end if;

-- Calling conversion functions when the digital value goes from '0' to '1'.

       if probe  = 0 then
        if delta_real  <= Ref_time_real then -- when delta is equal to Ref_time.
          wait for 0 ns;
          ANALOG_OUTPUT <= digi2ana(LOGIC_IN,t_real); 
        elsif delta_real > Ref_time_real then -- delta is greater than Ref_time.
          wait for 0 ns;
          ANALOG_OUTPUT <= digi2ana_delay(LOGIC_IN,t_real,delta_real);
        end if;

-- Calling conversion functions when the digital value goes from '1' to '0'.

       elsif probe = 1 then
        if delta_real <= Ref_time_real then  -- delta is equal to Ref_time. 
          wait for 0 ns;
          ANALOG_OUTPUT <= digi2ana_inv(LOGIC_IN,t_real);
        elsif delta_real > Ref_time_real then -- delta is greater than Ref_time.
          wait for 0 ns;
          ANALOG_OUTPUT <= digi2ana_delay_inv(LOGIC_IN,t_real,delta_real);
        end if;
       end if;
      wait for 1 ns;
     
  end process p3; 

end D2A;
