-- This is the structural description of an edge triggered d_flipflop
-- It is built up from nand_gates
-- The design is got from the book on circuit design by Mano

use work.nand_gate;
use work.INTERFACE_PACK.all;

entity d_ff is
 generic (nand_delay : time);
 port(clock : in SWITCH_LEVEL;
      data : in SWITCH_LEVEL;
      q, qb : out SWITCH_LEVEL);
end d_ff;

architecture d_ff of d_ff is

component nand_gate 
 generic (width : integer := 2;
          delay_time : time := 0 ns);
 port(input : in SWITCH_LEVEL_VECTOR((width-1) downto 0);
      output : out SWITCH_LEVEL); 
end component;

for all: nand_gate use entity work.nand_gate(simple_nand);

signal a, b, c, d, e, f, ndata, nclock, qint, qbint : SWITCH_LEVEL;

begin

nd1: nand_gate generic map(2,nand_delay)
     port map(input(1) => d, input(0) => b,
              output => a);

nd2: nand_gate generic map(2,nand_delay)
     port map(input(1) => clock, input(0) => a,
               output => b);

nd3: nand_gate generic map(3,nand_delay)
     port map(input(2) => clock, input(1) => b, input(0) => d, output => c);

nd4: nand_gate generic map(2,nand_delay)
     port map(input(1) => c, input(0) => data,
              output => d);

nd5: nand_gate generic map(2,nand_delay)
     port map(input(1) => b, input(0) => qbint, output => qint);

nd6: nand_gate generic map(2,nand_delay)
     port map(input(1) => c, input(0) => qint, output => qbint);

q <= qint;
qb <= qbint;

end d_ff;
