--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
--                    NUMERIC_BIT PACKAGE VERSION 3.2                          |
-- Last changes:                                                               |    
--       - procedures 55, 56, 1006, 1007 deleted;                              |
--       - most subprogram headers reduced to one line;                        |      
--       - changed gt, lt, lte, gte, eq function names to ">", "<", ">=",      |
--         "<=" and "=" respectively.                                          |
--=============================================================================+



package NUMERIC_BIT is

   -- Vector types

   type UNSIGNED is array ( NATURAL range <> ) of BIT;
   type SIGNED is array ( NATURAL range <> ) of BIT;

   -- Standard null range array constants

   constant nau : UNSIGNED (0 downto 1) := (others => '0');
   constant nas : SIGNED (0 downto 1) := (others => '0');

--==============================================================================
-- Signature:       1   f    "+"      BV n c  BV n c  BV n V   
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : BIT_VECTOR;
               CONSTANT R : BIT_VECTOR ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:       2   f    "+"      BIT 1 c BV n c  BV n V   
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : BIT;
               CONSTANT R : BIT_VECTOR ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:       3   f    "+"      BV n c  BIT 1 c BV n V   
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : BIT_VECTOR;
               CONSTANT R : BIT ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:       4   f    "+"      BIT 1 c BIT 1 c BV 1 V   
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : BIT;
               CONSTANT R : BIT ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:       5   f    "-"      BV n c  BV n c  BV n V   
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : BIT_VECTOR;
               CONSTANT R : BIT_VECTOR ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:       6   f    "-"      BIT 1 c BV n c  BV n V   
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : BIT;
               CONSTANT R : BIT_VECTOR ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:       7   f    "-"      BV n c  BIT 1 c BV n V   
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : BIT_VECTOR;
               CONSTANT R : BIT ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:       8   f    "-"      BIT 1 c BIT 1 c BV 1 V   
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : BIT;
               CONSTANT R : BIT ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     21 f  "+"     UBV m c UBV n c UBV T V      
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : UNSIGNED;
               CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     22 f  "-"     UBV m c UBV n c UBV T V      
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : UNSIGNED;
               CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     23 f  "*"     UBV m c UBV n c UBV m+n V    
--------------------------------------------------------------------------------
function "*" ( CONSTANT L : UNSIGNED;
               CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     24 f  "/"     UBV m c UBV n c UBV m V     
--------------------------------------------------------------------------------
function "/" ( CONSTANT L : UNSIGNED;
               CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     29 f  "+"    BV2 m c BV2 n c BV2 T V      
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : SIGNED;
               CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     30 f  "-"    BV2 m c BV2 n c BV2 T V      
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : SIGNED;
               CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     31 f  "*"    BV2 m c BV2 n c BV2 m+n V    
--------------------------------------------------------------------------------
function "*" ( CONSTANT L : SIGNED;
               CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     32 f  "/"    BV2 m c BV2 n c BV2 m V         
--------------------------------------------------------------------------------
function "/" ( CONSTANT L : SIGNED;
               CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    39 p  add    BV2 m c BV2 n c BIT 1 c  BIT 1 V  BV2 T V      
--------------------------------------------------------------------------------
procedure add ( CONSTANT Arg1 : in SIGNED;
                CONSTANT Arg2 : in SIGNED;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out SIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    40 p  sub    BV2 m c BV2 n c BIT 1 c  BIT 1 V  BV2 T V      
--------------------------------------------------------------------------------
procedure sub ( CONSTANT Arg1 : in SIGNED;
                CONSTANT Arg2 : in SIGNED;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out SIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    43 p  add    UBV m c UBV n c BIT 1 c  BIT 1 V  UBV T V      
--------------------------------------------------------------------------------
procedure add ( CONSTANT Arg1 : in UNSIGNED;
                CONSTANT Arg2 : in UNSIGNED;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out UNSIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    44 p  sub    UBV m c UBV n c BIT 1 c  BIT 1 V  UBV T V      
--------------------------------------------------------------------------------
procedure sub ( CONSTANT Arg1 : in UNSIGNED;
                CONSTANT Arg2 : in UNSIGNED;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out UNSIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    59 pdiv div BV2 m c  BV2 n c BV2 m V  BV2 n V  BIT 1 V     
--------------------------------------------------------------------------------
procedure div ( CONSTANT Dividend : in SIGNED;
                 CONSTANT Divisor : in SIGNED;
                         Quotient : out SIGNED;
                        Remainder : out SIGNED;
                         Dvd_by_0 : out BIT );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    60 pdiv div UBV m c  UBV n c UBV m V  UBV n V  BIT 1 V     
--------------------------------------------------------------------------------
procedure div ( CONSTANT Dividend : in UNSIGNED;
                 CONSTANT Divisor : in UNSIGNED;
                         Quotient : out UNSIGNED;
                        Remainder : out UNSIGNED;
                         Dvd_by_0 : out BIT );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    61 f "abs"            BV2 n c   BV2 n V       
--------------------------------------------------------------------------------
function "abs" ( CONSTANT x : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    63 f "rem"  BV2 m c BV2 n c BV2 n V  
--------------------------------------------------------------------------------
function "rem" ( CONSTANT L : SIGNED;
                 CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    64 f "rem"  UBV m c UBV n c UBV n V 
--------------------------------------------------------------------------------
function "rem" ( CONSTANT L : UNSIGNED;
                 CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    65 f "mod"  BV2 m c BV2 n c BV2 n V 
--------------------------------------------------------------------------------
function "mod" ( CONSTANT L : SIGNED;
                 CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    66 f "mod"  UBV m c UBV n c UBV n V 
--------------------------------------------------------------------------------
function "mod" ( CONSTANT L : UNSIGNED;
                 CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    67  f  ">"    UBV m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">"  ( CONSTANT L : UNSIGNED;
               CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    68  f  ">"    BV2 m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function ">"  ( CONSTANT L : SIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    69  f  ">"    UBV m c BV2 n c BOOL 1 V   
--------------------------------------------------------------------------------
function ">"  ( CONSTANT L : UNSIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    70  f  ">"    BV2 m c UBV n c BOOL 1 V   
--------------------------------------------------------------------------------
function ">"  ( CONSTANT L : SIGNED;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    71  f  ">="   UBV m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">=" ( CONSTANT L : UNSIGNED;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    72  f  ">="   BV2 m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function ">=" ( CONSTANT L : SIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    73  f  ">="   UBV m c BV2 n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">=" ( CONSTANT L : UNSIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    74  f  ">="   BV2 m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">=" ( CONSTANT L : SIGNED;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    75  f  "<"   UBV m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<"  ( CONSTANT L : UNSIGNED;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    76  f  "<"   BV2 m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function "<"  ( CONSTANT L : SIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    77  f  "<"   UBV m c BV2 n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<"  ( CONSTANT L : UNSIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    78  f  "<"    BV2 m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<"  ( CONSTANT L : SIGNED;
               CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    79  f  "<="   UBV m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<=" ( CONSTANT L : UNSIGNED;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    80  f  "<="   BV2 m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function "<=" ( CONSTANT L : SIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    81  f  "<="   UBV m c BV2 n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<=" ( CONSTANT L : UNSIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    82  f  "<="   BV2 m c UBV n c BOOL 1 V      
--------------------------------------------------------------------------------
function "<=" ( CONSTANT L : SIGNED;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    83  f  "="    UBV m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function "="  ( CONSTANT L : UNSIGNED;
               CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    84  f  "="    BV2 m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function "="  ( CONSTANT L : SIGNED;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    85  f  "="    UBV m c BV2 n c BOOL 1 V    
--------------------------------------------------------------------------------
function "="  ( CONSTANT L : UNSIGNED;
               CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    86  f  "="    BV2 m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function "="  ( CONSTANT L : SIGNED;
               CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1090 f to_integer UBV x c INT x V
-- Notes: - arg length should be less than 32, else an ERROR is reported, and 0 
--          is returned 
--        - for a null range array the return value is 0      
--------------------------------------------------------------------------------
function to_integer ( CONSTANT arg : UNSIGNED ) return INTEGER;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1091 f to_integer BV2 x c INT x V  
--------------------------------------------------------------------------------
function to_integer ( CONSTANT arg : SIGNED ) return INTEGER;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1092 f to_unsigned INT x c  NAT x UBV ((2), 0 if (1)=nul) V 
--------------------------------------------------------------------------------
function to_unsigned ( CONSTANT arg : INTEGER;
                               size : NATURAL ) return UNSIGNED; 
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1093 f to_signed INT x c BV2 x V
--------------------------------------------------------------------------------
function to_signed ( CONSTANT arg : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1094 f to_unsigned BV2 x c UBV x V
--------------------------------------------------------------------------------
function to_unsigned ( CONSTANT arg : SIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1095 f to_signed UBV x c BV2 x V
--------------------------------------------------------------------------------
function to_signed ( CONSTANT arg : UNSIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    87  f "+"   INT x c  UBV x c UBV x V
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : INTEGER;
               CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    88  f "-"   INT x c  UBV x c UBV x V
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : INTEGER;
               CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    89  f "*"   INT x c  UBV x c UBV x V
--------------------------------------------------------------------------------
function "*" ( CONSTANT L : INTEGER;
               CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    90  f "/"   INT x c  UBV x c UBV x V
--------------------------------------------------------------------------------
function "/" ( CONSTANT L : INTEGER;
               CONSTANT R : UNSIGNED ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    91  f "+"   UBV x c  INT x c UBV x V
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : UNSIGNED;
               CONSTANT R : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    92  f "-"   UBV x c  INT x c UBV x V
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : UNSIGNED;
               CONSTANT R : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    93  f "*"   UBV x c  INT x c UBV x V
--------------------------------------------------------------------------------
function "*" ( CONSTANT L : UNSIGNED;
               CONSTANT R : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    94  f "/"   UBV x c  INT x c UBV x V
--------------------------------------------------------------------------------
function "/" ( CONSTANT L : UNSIGNED;
               CONSTANT R : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    95  f "+"   INT x c  BV2 x c BV2 x V
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : INTEGER;
               CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    96  f "-"   INT x c  BV2 x c BV2 x V
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : INTEGER;
               CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    97  f "*"   INT x c  BV2 x c BV2 x V
--------------------------------------------------------------------------------
function "*" ( CONSTANT L : INTEGER;
               CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    98  f "/"   INT x c  BV2 x c BV2 x V
--------------------------------------------------------------------------------
function "/" ( CONSTANT L : INTEGER;
               CONSTANT R : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    49  f "+"   BV2 x c  INT x c BV2 x V
--------------------------------------------------------------------------------
function "+" ( CONSTANT L : SIGNED;
               CONSTANT R : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    50  f "-"   BV2 x c  INT x c BV2 x V
--------------------------------------------------------------------------------
function "-" ( CONSTANT L : SIGNED;
               CONSTANT R : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    51  f "*"   BV2 x c  INT x c BV2 x V
--------------------------------------------------------------------------------
function "*" ( CONSTANT L : SIGNED;
               CONSTANT R : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    52  f "/"   BV2 x c  INT x c BV2 x V
--------------------------------------------------------------------------------
function "/" ( CONSTANT L : SIGNED;
               CONSTANT R : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1001 p add  INT x c  UBV n c  BIT 1 c  BIT 1 V  UBV n V 
--------------------------------------------------------------------------------
procedure add ( CONSTANT Arg1 : in INTEGER;
                CONSTANT Arg2 : in UNSIGNED;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out UNSIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1002 p add  INT x c  BV2 n c  BIT 1 c  BIT 1 V  BV2 n V 
--------------------------------------------------------------------------------
procedure add ( CONSTANT Arg1 : in INTEGER;
                CONSTANT Arg2 : in SIGNED;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out SIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1003 p sub  INT x c  UBV n c  BIT 1 c  BIT 1 V  UBV n V 
--------------------------------------------------------------------------------
procedure sub ( CONSTANT Arg1 : in INTEGER;
                CONSTANT Arg2 : in UNSIGNED;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out UNSIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1004 p sub  UBV x c  INT n c  BIT 1 c  BIT 1 V  UBV n V 
--------------------------------------------------------------------------------
procedure sub ( CONSTANT Arg1 : in UNSIGNED;
                CONSTANT Arg2 : in INTEGER;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out UNSIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1005 p sub  INT x c  BV2 n c  BIT 1 c  BIT 1 V  BV2 n V 
--------------------------------------------------------------------------------
procedure sub ( CONSTANT Arg1 : in INTEGER;
                CONSTANT Arg2 : in SIGNED;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out SIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1006 p sub  BV2 x c  INT n c  BIT 1 c  BIT 1 V  BV2 n V 
--------------------------------------------------------------------------------
procedure sub ( CONSTANT Arg1 : in SIGNED;
                CONSTANT Arg2 : in INTEGER;
                CONSTANT Arg3 : in BIT;
                         Arg4 : out BIT;
                         Arg5 : out SIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1009 p div  INT m c  UBV n c UBV m V  UBV n V  BIT 1 V        
--------------------------------------------------------------------------------
procedure div ( CONSTANT Dividend : in INTEGER;
                 CONSTANT Divisor : in UNSIGNED;
                         Quotient : out UNSIGNED;
                        Remainder : out UNSIGNED;
                         Dvd_by_0 : out BIT );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1010 p div  UBV m c  INT n c UBV m V  UBV n V  BIT 1 V        
--------------------------------------------------------------------------------
procedure div ( CONSTANT Dividend : in UNSIGNED;
                 CONSTANT Divisor : in INTEGER;
                         Quotient : out UNSIGNED;
                        Remainder : out UNSIGNED;
                         Dvd_by_0 : out BIT );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1011 p div  INT m c  BV2 n c BV2 m V  BV2 n V  BIT 1 V        
--------------------------------------------------------------------------------
procedure div ( CONSTANT Dividend : in INTEGER;
                 CONSTANT Divisor : in SIGNED;
                         Quotient : out SIGNED;
                        Remainder : out SIGNED;
                         Dvd_by_0 : out BIT );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:   1012 p div  BV2 m c  INT n c BV2 m V  BV2 n V  BIT 1 V        
--------------------------------------------------------------------------------
procedure div ( CONSTANT Dividend : in SIGNED;
                 CONSTANT Divisor : in INTEGER;
                         Quotient : out SIGNED;
                        Remainder : out SIGNED;
                         Dvd_by_0 : out BIT );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1067  f  ">"    INT m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">"  ( CONSTANT L : INTEGER;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1068  f  ">"    INT m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function ">"  ( CONSTANT L : INTEGER;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1069  f  ">"    UBV m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">"  ( CONSTANT L : UNSIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1070  f  ">"    BV2 m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">"  ( CONSTANT L : SIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1071  f  ">="   INT m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">=" ( CONSTANT L : INTEGER;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1072  f  ">="   INT m c BV2 n c BOOL 1 V       
-- Notes: 
--------------------------------------------------------------------------------
function ">=" ( CONSTANT L : INTEGER;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1073  f  ">="   UBV m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">=" ( CONSTANT L : UNSIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1074  f  ">="   BV2 m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function ">=" ( CONSTANT L : SIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1075  f  "<"    INT m c UBV n c BOOL 1 V     
--------------------------------------------------------------------------------
function "<"  ( CONSTANT L : INTEGER;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1076  f  "<"    INT m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function "<"  ( CONSTANT L : INTEGER;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1077  f  "<"    UBV m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<"  ( CONSTANT L : UNSIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1078  f  "<"    BV2 m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<"  ( CONSTANT L : SIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1079  f  "<="   INT m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<=" ( CONSTANT L : INTEGER;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1080  f  "<="   INT m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function "<=" ( CONSTANT L : INTEGER;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1081  f  "<="   UBV m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function "<=" ( CONSTANT L : UNSIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1082  f  "<="   BV2 m c INT n c BOOL 1 V      
--------------------------------------------------------------------------------
function "<=" ( CONSTANT L : SIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1083  f  "="    INT m c UBV n c BOOL 1 V    
--------------------------------------------------------------------------------
function "="  ( CONSTANT L : INTEGER;
                CONSTANT R : UNSIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1084  f  "="    INT m c BV2 n c BOOL 1 V       
--------------------------------------------------------------------------------
function "="  ( CONSTANT L : INTEGER;
                CONSTANT R : SIGNED ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1085  f  "="    UBV m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function "="  ( CONSTANT L : UNSIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1086  f  "="    BV2 m c INT n c BOOL 1 V    
--------------------------------------------------------------------------------
function "="  ( CONSTANT L : SIGNED;
                CONSTANT R : INTEGER ) return BOOLEAN;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1027  f  sll  UBV n c INT x c UBV n V
--------------------------------------------------------------------------------
function sll ( CONSTANT  arg  : UNSIGNED;
               CONSTANT count : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1028  f  srl  UBV n c INT x c UBV n V
--------------------------------------------------------------------------------
function srl ( CONSTANT  arg  : UNSIGNED;
               CONSTANT count : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1029  f  sla  UBV n c INT x c UBV n V
--------------------------------------------------------------------------------
function sla ( CONSTANT  arg  : UNSIGNED;
               CONSTANT count : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1030  f  sra  UBV n c INT x c UBV n V
--------------------------------------------------------------------------------
function sra ( CONSTANT  arg  : UNSIGNED;
               CONSTANT count : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1031  f  rol  UBV n c INT x c UBV n V
--------------------------------------------------------------------------------
function rol ( CONSTANT  arg  : UNSIGNED;
               CONSTANT count : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1032  f  ror  UBV n c INT x c UBV n V         
--------------------------------------------------------------------------------
function ror ( CONSTANT  arg  : UNSIGNED;
               CONSTANT count : INTEGER ) return UNSIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1033  f  sll  BV2 n c INT x c BV2 n V
--------------------------------------------------------------------------------
function sll ( CONSTANT  arg  : SIGNED;
               CONSTANT count : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1034  f  srl  BV2 n c INT x c BV2 n V 
--------------------------------------------------------------------------------
function srl ( CONSTANT  arg  : SIGNED;
               CONSTANT count : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1035  f  sla  BV2 n c INT x c BV2 n V
--------------------------------------------------------------------------------
function sla ( CONSTANT  arg  : SIGNED;
               CONSTANT count : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1036  f  sra  BV2 n c INT x c BV2 n V
--------------------------------------------------------------------------------
function sra ( CONSTANT  arg  : SIGNED;
               CONSTANT count : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1037  f  rol  BV2 n c INT x c BV2 n V
--------------------------------------------------------------------------------
function rol ( CONSTANT  arg  : SIGNED;
               CONSTANT count : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1038  f  ror  BV2 n c INT x c BV2 n V     
--------------------------------------------------------------------------------
function ror ( CONSTANT  arg  : SIGNED;
               CONSTANT count : INTEGER ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1019  f  sll  BV n c INT x c BV n V
--------------------------------------------------------------------------------
function sll ( CONSTANT  arg  : BIT_VECTOR;
               CONSTANT count : INTEGER ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1020  f  srl  BV n c INT x c BV n V
--------------------------------------------------------------------------------
function srl ( CONSTANT  arg  : BIT_VECTOR;
               CONSTANT count : INTEGER ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1021  f  sla  BV n c INT x c BV n V
--------------------------------------------------------------------------------
function sla ( CONSTANT  arg  : BIT_VECTOR;
               CONSTANT count : INTEGER ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1022  f  sra  BV n c INT x c BV n V
--------------------------------------------------------------------------------
function sra ( CONSTANT  arg  : BIT_VECTOR;
               CONSTANT count : INTEGER ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1023  f  rol  BV n c INT x c BV n V
--------------------------------------------------------------------------------
function rol ( CONSTANT  arg  : BIT_VECTOR;
               CONSTANT count : INTEGER ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:    1024  f  ror  BV n c INT x c BV n V   
--------------------------------------------------------------------------------
function ror ( CONSTANT  arg  : BIT_VECTOR;
               CONSTANT count : INTEGER ) return BIT_VECTOR;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     1045  f sxt BV2 n c NAT x c BV2 result_size V 
-- Notes:  When arg range is null and size > 0, return value is (others => '0').
--------------------------------------------------------------------------------
function sxt ( CONSTANT arg : SIGNED;
          CONSTANT new_size : NATURAL ) return SIGNED;
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     1046  p sxt BV2 n c BV2 x V 
--------------------------------------------------------------------------------
procedure sxt ( CONSTANT arg1 : SIGNED;
                         arg2 : inout SIGNED );
--------------------------------------------------------------------------------

--==============================================================================
-- Signature:     1047  f "-" BV2 n c BV2 n V
--------------------------------------------------------------------------------
function "-" ( CONSTANT arg : SIGNED ) return SIGNED;
--------------------------------------------------------------------------------

end NUMERIC_BIT;

