use std.textio.all;
use work.waves_logic.all;
use work.waves_interface.all;
use work.waves_codes.all;
use work.waves_device.all;
use work.waves_objects.all;
package waves_generator is
  procedure waveform(signal connect : inout waves_port_list;
                     signal connect_m : in waves_match_list);
end waves_generator;
package body waves_generator is
  procedure waveform(signal connect : inout waves_port_list;
                     signal connect_m : in waves_match_list) is
    constant t0 : event_time := etime(0 ns);
    constant input_pins : pinset := new_pinset((
          st,te,ls,re,
          y31,y30,y29,y28,y27,y26,y25,y24,y23,y22,y21,y20,y19,y18,y17,y16,
          y15,y14,y13,y12,y11,y10,y9,y8,y7,y6,y5,y4,y3,y2,y1,y0,
          s31,s30,s29,s28,s27,s26,s25,s24,s23,s22,s21,s20,s19,s18,s17,s16,
          s15,s14,s13,s12,s11,s10,s9,s8,s7,s6,s5,s4,s3,s2,s1,s0));
    constant output_pins : pinset := all_pins and not input_pins;
    constant input_fs : frame_set :=
      frame_event((logic_i0,t0)) +
      frame_event((logic_i1,t0));
    constant output_fs : frame_set :=
      frame_event((logic_o0,t0)) +
      frame_event((logic_o1,t0));
    constant fsa : frame_set_array :=
      new_frame_set_array(input_fs,input_pins) +
      new_frame_set_array(output_fs,output_pins);
    variable td : time_data := new_time_data(fsa);
    variable slice : file_slice := new_file_slice;
    file lfsr_data : text is in "waves_external";
    constant match_pins : pinset := all_pins;
  begin
    match(connect,hold,input_pins);
    match(connect,sample,output_pins);
    loop
      read_file_slice(lfsr_data,slice);
      exit when slice.end_of_file;
      apply(connect,slice.codes.all,delay(slice.fs_time),td);
      assert (match(connect_m,match_pins)) report "no match" severity failure;
    end loop;
  end waveform;
end waves_generator;
