use std.textio.all;
use work.waves_system.all;
use work.waves_logic.all;
use work.waves_interface.all;
use work.waves_device.all;
use work.waves_objects.all;
use work.waves_generator.all;
entity test is end;
architecture test of test is
  
  component prpt 
    port(seed       : in bit_vector(31 downto 0);
         load_seed  : in bit;  
         polynomial : in bit_vector(31 downto 0);
         reset      : in bit;
         clock1     : in bit;
         clock1_bar : in bit;
         clock2     : in bit;
         clock2_bar : in bit;
         test_enable: in bit;
         pattern    : out bit_vector(31 downto 0));
  end component;

  for prpt1 : prpt use entity work.prpt(structural);
  for prpt2 : prpt use entity work.prpt(beh);
  for prpt3 : prpt use configuration work.prptconf;

  component inv
    generic(constant tPLH:TIME:=0 ns;
            constant tPHL:TIME:=0 ns);
    port (signal A:in bit;
          signal B:out bit);
  end component;

  for all : inv use entity work.inv( inv );

  component master_clock 
    generic
      ( constant clock_low_time  : time := 60 ns;
        constant duty_cycle_time : time := 40 ns);
    port
      ( master_go                : in bit;
        Phi1                     : buffer bit := '1');
  end component;

  for all : master_clock use entity work.master_clock(master_clock );

  component slave_clock 
    generic
      ( constant pulse_width  : time := 40 ns;
        constant pulse_delay  : time := 10 ns);
    port
      ( external_trigger         : in bit;
        Clock_out                : out bit := '0');
  end component;

  for all : slave_clock use entity work.slave_clock(slave_clock );

  component or_gate 
    port (X, Y     : in bit;
          Output   : out bit);
  end component;
  
  for all : or_gate use entity work.or_gate(or_gate);

  component and_gate
    port  (signal X,Y:in bit;
           signal Output:out bit);
  end component;

  for all : and_gate use entity work.and_gate( and_gate );

  function data_to_char(data : logic_value) return character is
  begin
    case data is
      when logic_i0 => return '0'; 
      when logic_i1 => return '1';
      when logic_o0 => return '0'; 
      when logic_o1 => return '1';
    end case;
  end data_to_char;
  function data_to_bit(data : logic_value) return bit is
  begin
    case data is
      when logic_i0 => return '0'; 
      when logic_i1 => return '1';
      when logic_o0 => return '0'; 
      when logic_o1 => return '1';
    end case;
  end data_to_bit;
  subtype test_pin_range is integer range
    test_pins'pos(test_pins'left) + 1 to
    test_pins'pos(test_pins'right) + 1;
  signal test_vector : bit_vector(test_pin_range);
  alias pat1 : bit_vector(31 downto 0) is test_vector(69 to 100);
  alias polynomial : bit_vector(31 downto 0) is test_vector(5 to 36);
  alias seed : bit_vector(31 downto 0) is test_vector(37 to 68);
  alias load_seed : bit is test_vector(3);
  alias reset : bit is test_vector(4);
  signal clock1 : bit;
  signal clock1_bar : bit;
  signal clock2 : bit;
  signal clock2_bar : bit;
  signal CP : bit;
  alias stop : bit is test_vector(1);
  signal pat2 : bit_vector(31 downto 0);
  signal pat3 : bit_vector(31 downto 0);
  signal interm1,interm2 : bit;
  alias test_enable : bit is test_vector(2);
  signal connect : waves_port_list(test_pin_range);
  signal connect_m : waves_match_list(test_pin_range);

begin

  waves : waveform(connect,connect_m);
  read : process(connect)
         begin
          stop <= transport data_to_bit(logic_value'val(connect(1).l_value));
          test_enable <= transport
            data_to_bit(logic_value'val(connect(2).l_value));
          load_seed <= transport
            data_to_bit(logic_value'val(connect(3).l_value));
          reset <= transport data_to_bit(logic_value'val(connect(4).l_value));
          for i in polynomial'high downto polynomial'low loop
            polynomial(i) <= transport
              data_to_bit(logic_value'val(connect(36-i).l_value));
          end loop;
          for i in seed'high downto seed'low loop
            seed(i) <= transport
              data_to_bit(logic_value'val(connect(68-i).l_value));
          end loop;
         end process;
  inv1 : inv port map(clock1,clock1_bar);
  inv2 : inv port map(clock2,clock2_bar);
  prpt1 : prpt 
        port map(seed,load_seed,polynomial,reset,clock1,clock1_bar,
                 clock2,clock2_bar,test_enable,pat1);
  prpt2 : prpt 
        port map(seed,load_seed,polynomial,reset,clock1,clock1_bar,
                 clock2,clock2_bar,test_enable,pat2);
  prpt3 : prpt 
        port map(seed,load_seed,polynomial,reset,clock1,clock1_bar,
                 clock2,clock2_bar,test_enable,pat3);

  master_clock1 : master_clock port map(stop,CP);
  slave_clock1 : slave_clock port map(CP,clock2);
  and_gate1 : and_gate port map(CP,test_enable,interm1);
  and_gate2 : and_gate port map(load_seed,CP,interm2);
  or_gate1 : or_gate port map(interm1,interm2,clock1);

  match_proc : process
    variable first_time : boolean := true;
    type ev_ptr is access system_event_value;
    variable ev : ev_ptr;
    variable rel_flag,dir_flag : boolean;
--variable outline : line;
--file outfile : text is out "match.out";
  begin
  if first_time then
    for j in test_pin_range loop
      connect_m(j).m_value <= true;
    end loop;
    first_time := false;
  end if;
  wait until pat1'stable;
  for i in test_pin_range loop
    ev := 
 new system_event_value'(value_dictionary(logic_value'val(connect(i).l_value)));
    dir_flag := false;
    rel_flag := false;
    for k in ev.all'range loop
      if ev(k).kind = direction_kind then
        if ev(k).value = direction_type'pos(response) then
          dir_flag := true;
        end if;
      elsif ev(k).kind = relevance_kind then
        if ev(k).value = relevance_type'pos(required) then
          rel_flag := true;
        end if;
      end if;
    end loop;
    if (connect(i).m_control = sample) and dir_flag and rel_flag then
      if (test_vector(i) = pat2(100-i)) and (test_vector(i) = pat3(100-i)) then
        connect_m(i).m_value <= connect_m(i).m_value and true;
      else
        connect_m(i).m_value <= connect_m(i).m_value and false;
--        write(outline,now);write(outline,i);
--        write(outline,test_vector(i));
--        write(outline,data_to_bit(logic_value'val(connect(i).l_value)));
--        writeline(outfile,outline);
      end if;
    end if;
  end loop;
  end process;

  view : process(test_enable,load_seed,stop,reset,polynomial,seed)
           variable outline : line;
           file outfile : text is out "waves.out";
         begin
           write(outline,now);
           writeline(outfile,outline);
           write(outline,string'("stop : "));
           write(outline,stop);
           writeline(outfile,outline);
           write(outline,string'("test_enable : "));
           write(outline,test_enable);
           writeline(outfile,outline);
           write(outline,string'("load_seed : "));
           write(outline,load_seed);
           writeline(outfile,outline);
           write(outline,string'("reset : "));
           write(outline,reset);
           writeline(outfile,outline);
           write(outline,string'("polynomial : "));
           for i in polynomial'high downto polynomial'low loop
             write(outline,polynomial(i));
           end loop;
           writeline(outfile,outline);
           write(outline,string'("seed : "));
           for i in seed'high downto seed'low loop
             write(outline,seed(i));
           end loop;
           writeline(outfile,outline);
           write(outline,string'("pattern : "));
           for i in pat1'high downto pat1'low loop
             write(outline,pat1(i));
           end loop;
           writeline(outfile,outline);
         end process;           

  lfsr_out : process(pat1)
               variable outline : line;
               file out_lfsr : text is out "lfsr.out";
             begin
               write(outline,stop);
               write(outline,test_enable);
               write(outline,load_seed);
               write(outline,reset);
               for i in polynomial'high downto polynomial'low loop
                 write(outline,polynomial(i));
               end loop;
               for i in seed'high downto seed'low loop
                 write(outline,seed(i));
               end loop;
               write(outline,string'(" : "));
               write(outline,now);
               writeline(out_lfsr,outline);
               for i in pat1'high downto pat1'low loop
                 write(outline,pat1(i));
               end loop;
               writeline(out_lfsr,outline);
             end process;
end test;
