--entity prpt is
--  port(seed       : in bit_vector(31 downto 0);
--       load_seed  : in bit;  
--       polynomial : in bit_vector(31 downto 0);
--       reset      : in bit;
--       clock1     : in bit;
--       clock1_bar : in bit;
--       clock2     : in bit;
--       clock2_bar : in bit;
--       test_enable: in bit;
--       pattern    : out bit_vector(31 downto 0));
--begin
--  assert (((not clock1 = clock1_bar) or (not clock1'stable(2 ns))) 
--    or (now = 0 ns)) report
--    "bad clock1 result" severity failure;
----  assert ((not clock2 = clock2_bar) or (not clock2'stable(2 ns))) report
----    "bad clock2 result" severity failure;
--end prpt;

architecture struct_generate of prpt is

  component prpt_stage 
    port(seed       : in bit;
         load_seed  : in bit;
         polynomial : in bit;
         feed_in    : in bit;
         reset      : in bit;
         input      : in bit;
         clock1     : in bit;
         clock1_bar : in bit;
         clock2     : in bit;
         clock2_bar : in bit;
         test_enable: in bit;
         feed_out   : out bit;
         output     : out bit);
  end component;


  component prpt_stage1 
    port(seed       : in bit;
         load_seed  : in bit;
         reset      : in bit;
         input      : in bit;
         clock1     : in bit;
         clock1_bar : in bit;
         clock2     : in bit;
         clock2_bar : in bit;
         test_enable: in bit;
         output     : out bit);
  end component;

  for all : prpt_stage1 use entity work.prpt_stage1(structural);

  component and_gate
    port  (signal X,Y:in bit;
           signal Output:out bit);
  end component;

  for all : and_gate use entity work.and_gate( and_gate );

  component inv
    generic(constant tPLH:TIME:=0 ns;
            constant tPHL:TIME:=0 ns);
    port (signal A:in bit;
          signal B:out bit);
  end component;

  signal feedback : bit_vector(31 downto 0);
  signal i_o,temp : bit_vector(31 downto 0);

begin
 
  prpt_stage1_1 : prpt_stage1
    port map(seed(31),load_seed,reset,feedback(31),clock1,clock1_bar,
             clock2,clock2_bar,test_enable,i_o(31)); 

  prpt : for i in 31 downto 1 generate
    prpt_stage_i : prpt_stage 
      port map(seed(i-1),load_seed,polynomial(i),feedback(i-1),
               reset,i_o(i),clock1,clock1_bar,clock2,clock2_bar,
               test_enable,feedback(i),i_o(i-1));
    end generate;

  and_gate1 : and_gate port map(polynomial(0),i_o(0),feedback(0));

  inv_inv : for i in 0 to 31 generate
    invA : inv port map(i_o(i),temp(i));
    invB : inv port map(temp(i),pattern(i));
    end generate;

end struct_generate;
