package pack is
  function get_length(polynomial : bit_vector(31 downto 0)) return integer;
  procedure binary_div(divisor,remainder : inout bit_vector(32 downto 0);
                       real_length : in integer;
                       shift_count : inout integer;
                       shift_bit : inout bit);
  function get_shift_count(remainder : bit_vector(32 downto 0)) return integer;
end pack;
package body pack is
  function get_length(polynomial : bit_vector(31 downto 0)) return integer is
    variable count : integer := 0;
  begin
    for i in polynomial'low to polynomial'high loop
      exit when polynomial(i) = '1';
      count := count + 1;
    end loop;
    count := ((polynomial'high - polynomial'low) + 1) - count;
    return(count);
  end get_length;
  procedure binary_div(divisor,remainder : inout bit_vector(32 downto 0);
                       real_length : in integer;
                       shift_count : inout integer;
                       shift_bit : inout bit) is
  begin
    if shift_count > 0 then
      shift_count := shift_count - 1;
      for i in divisor'high downto ((divisor'high - real_length) + 2) loop
        remainder(i) := remainder(i - 1);
      end loop;
      remainder((divisor'high - real_length) + 1) := '0';
      shift_bit := '0';
    else
      for i in divisor'high downto ((divisor'high - real_length) + 1) loop
        remainder(i) := remainder(i) xor divisor(i);
      end loop;
--      shift_count := 0;
--      for i in divisor'high downto ((divisor'high - real_length) + 1) loop
--        exit when remainder(i) = '1';
--        shift_count := shift_count + 1;
--      end loop;
      shift_count := get_shift_count(remainder);
      for i in divisor'high downto ((divisor'high - real_length) + 2) loop
        remainder(i) := remainder(i - 1);
      end loop;
      remainder((divisor'high - real_length) + 1) := '0';
      shift_count := shift_count - 1;
      shift_bit := '1';
    end if;
  end binary_div;
  function get_shift_count(remainder : bit_vector(32 downto 0)) 
                                           return integer is
    variable shift_count : integer := 0;
  begin
    for i in remainder'high downto remainder'low loop
      exit when remainder(i) = '1';
      shift_count := shift_count + 1;
    end loop;
    return(shift_count);
  end get_shift_count;
end pack;
