entity master_clock is
  generic
    ( constant clock_low_time  : time := 60 ns;
      constant duty_cycle_time : time := 40 ns);

  port
    ( master_go                : in bit;
      Phi1                     : buffer bit := '1');
end master_clock;

architecture master_clock of master_clock is

  begin

  process(master_go,phi1)
    begin
    if (master_go = '1') then
      case Phi1 is
        when '1' => Phi1 <= '0' after duty_cycle_time;
        when '0' => Phi1 <= '1' after clock_low_time;
        when others => assert false
             report " Master clock in undefined state"
             severity ERROR;
        end case;
      end if;
    end process;
  end master_clock;

